/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.document.DefaultElasticsearchDocumentFactory;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document.UpdateDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentResponse;
import java.io.IOException;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UpdateDocumentRequestExecutor.class})
public class UpdateDocumentRequestExecutorImpl
implements UpdateDocumentRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public UpdateDocumentResponse execute(UpdateDocumentRequest updateDocumentRequest) {
        try {
            UpdateRequestBuilder updateRequestBuilder = this.createUpdateRequestBuilder(updateDocumentRequest);
            UpdateResponse updateResponse = (UpdateResponse)updateRequestBuilder.get();
            RestStatus restStatus = updateResponse.status();
            UpdateDocumentResponse updateDocumentResponse = new UpdateDocumentResponse(restStatus.getStatus());
            return updateDocumentResponse;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected UpdateRequestBuilder createUpdateRequestBuilder(UpdateDocumentRequest updateDocumentRequest) throws IOException {
        Client client = this.elasticsearchConnectionManager.getClient();
        UpdateRequestBuilder updateRequestBuilder = UpdateAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        Document document = updateDocumentRequest.getDocument();
        updateRequestBuilder.setId(document.getUID());
        updateRequestBuilder.setIndex(updateDocumentRequest.getIndexName());
        if (updateDocumentRequest.isRefresh()) {
            updateRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        updateRequestBuilder.setType(document.get("type"));
        DefaultElasticsearchDocumentFactory elasticsearchDocumentFactory = new DefaultElasticsearchDocumentFactory();
        String elasticsearchDocument = elasticsearchDocumentFactory.getElasticsearchDocument(document);
        updateRequestBuilder.setDoc(elasticsearchDocument, XContentType.JSON);
        return updateRequestBuilder;
    }
}

