/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.document.DefaultElasticsearchDocumentFactory;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document.IndexDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentResponse;
import java.io.IOException;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IndexDocumentRequestExecutor.class})
public class IndexDocumentRequestExecutorImpl
implements IndexDocumentRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public IndexDocumentResponse execute(IndexDocumentRequest indexDocumentRequest) {
        try {
            IndexRequestBuilder indexRequestBuilder = this.createIndexRequestBuilder(indexDocumentRequest);
            IndexResponse indexResponse = (IndexResponse)indexRequestBuilder.get();
            RestStatus restStatus = indexResponse.status();
            IndexDocumentResponse indexDocumentResponse = new IndexDocumentResponse(restStatus.getStatus());
            return indexDocumentResponse;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected IndexRequestBuilder createIndexRequestBuilder(IndexDocumentRequest indexDocumentRequest) throws IOException {
        Client client = this.elasticsearchConnectionManager.getClient();
        IndexRequestBuilder indexRequestBuilder = IndexAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        Document document = indexDocumentRequest.getDocument();
        indexRequestBuilder.setId(document.getUID());
        indexRequestBuilder.setIndex(indexDocumentRequest.getIndexName());
        if (indexDocumentRequest.isRefresh()) {
            indexRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        indexRequestBuilder.setType(document.get("type"));
        DefaultElasticsearchDocumentFactory elasticsearchDocumentFactory = new DefaultElasticsearchDocumentFactory();
        String elasticsearchDocument = elasticsearchDocumentFactory.getElasticsearchDocument(document);
        indexRequestBuilder.setSource(elasticsearchDocument, XContentType.JSON);
        return indexRequestBuilder;
    }
}

