/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document.DeleteDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentResponse;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DeleteDocumentRequestExecutor.class})
public class DeleteDocumentRequestExecutorImpl
implements DeleteDocumentRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public DeleteDocumentResponse execute(DeleteDocumentRequest deleteDocumentRequest) {
        DeleteRequestBuilder deleteRequestBuilder = this.createDeleteRequestBuilder(deleteDocumentRequest);
        DeleteResponse deleteResponse = (DeleteResponse)deleteRequestBuilder.get();
        RestStatus restStatus = deleteResponse.status();
        DeleteDocumentResponse deleteDocumentResponse = new DeleteDocumentResponse(restStatus.getStatus());
        return deleteDocumentResponse;
    }

    protected DeleteRequestBuilder createDeleteRequestBuilder(DeleteDocumentRequest deleteDocumentRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        DeleteRequestBuilder deleteRequestBuilder = DeleteAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        deleteRequestBuilder.setId(deleteDocumentRequest.getUid());
        deleteRequestBuilder.setIndex(deleteDocumentRequest.getIndexName());
        if (deleteDocumentRequest.isRefresh()) {
            deleteRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        deleteRequestBuilder.setType(deleteDocumentRequest.getType());
        return deleteRequestBuilder;
    }
}

