/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.query;

import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.query.BaseMatchQueryTranslatorImpl;
import com.liferay.portal.search.elasticsearch6.internal.query.MatchQueryTranslator;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.search.MatchQuery;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={MatchQueryTranslator.class})
public class MatchQueryTranslatorImpl
extends BaseMatchQueryTranslatorImpl
implements MatchQueryTranslator {
    @Override
    public QueryBuilder translate(MatchQuery matchQuery) {
        String field = matchQuery.getField();
        MatchQuery.Type type = matchQuery.getType();
        String value = matchQuery.getValue();
        if (value.startsWith("\"") && value.endsWith("\"")) {
            type = MatchQuery.Type.PHRASE;
            if ((value = StringUtil.unquote((String)value)).endsWith("*")) {
                type = MatchQuery.Type.PHRASE_PREFIX;
            }
        }
        if (type == null || type == MatchQuery.Type.BOOLEAN) {
            return this.translateMatchQuery(field, value, matchQuery);
        }
        if (type == MatchQuery.Type.PHRASE) {
            return this.translateMatchPhraseQuery(field, value, matchQuery);
        }
        if (type == MatchQuery.Type.PHRASE_PREFIX) {
            return this.translateMatchPhrasePrefixQuery(field, value, matchQuery);
        }
        throw new IllegalArgumentException("Invalid match query type: " + type);
    }

    protected QueryBuilder translateMatchPhrasePrefixQuery(String field, String value, MatchQuery matchQuery) {
        MatchPhrasePrefixQueryBuilder matchPhrasePrefixQueryBuilder = QueryBuilders.matchPhrasePrefixQuery((String)field, (Object)value);
        if (Validator.isNotNull((String)matchQuery.getAnalyzer())) {
            matchPhrasePrefixQueryBuilder.analyzer(matchQuery.getAnalyzer());
        }
        if (matchQuery.getMaxExpansions() != null) {
            matchPhrasePrefixQueryBuilder.maxExpansions(matchQuery.getMaxExpansions().intValue());
        }
        if (matchQuery.getSlop() != null) {
            matchPhrasePrefixQueryBuilder.slop(matchQuery.getSlop().intValue());
        }
        if (!matchQuery.isDefaultBoost()) {
            matchPhrasePrefixQueryBuilder.boost(matchQuery.getBoost());
        }
        return matchPhrasePrefixQueryBuilder;
    }

    protected QueryBuilder translateMatchPhraseQuery(String field, String value, MatchQuery matchQuery) {
        MatchPhraseQueryBuilder matchPhraseQueryBuilder = QueryBuilders.matchPhraseQuery((String)field, (Object)value);
        if (Validator.isNotNull((String)matchQuery.getAnalyzer())) {
            matchPhraseQueryBuilder.analyzer(matchQuery.getAnalyzer());
        }
        if (matchQuery.getSlop() != null) {
            matchPhraseQueryBuilder.slop(matchQuery.getSlop().intValue());
        }
        if (!matchQuery.isDefaultBoost()) {
            matchPhraseQueryBuilder.boost(matchQuery.getBoost());
        }
        return matchPhraseQueryBuilder;
    }

    protected QueryBuilder translateMatchQuery(String field, String value, MatchQuery matchQuery) {
        MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)field, (Object)value);
        if (Validator.isNotNull((String)matchQuery.getAnalyzer())) {
            matchQueryBuilder.analyzer(matchQuery.getAnalyzer());
        }
        if (matchQuery.getCutOffFrequency() != null) {
            matchQueryBuilder.cutoffFrequency(matchQuery.getCutOffFrequency().floatValue());
        }
        if (matchQuery.getFuzziness() != null) {
            matchQueryBuilder.fuzziness((Object)Fuzziness.build((Object)matchQuery.getFuzziness()));
        }
        if (matchQuery.getFuzzyRewriteMethod() != null) {
            String matchQueryFuzzyRewrite = this.translate(matchQuery.getFuzzyRewriteMethod());
            matchQueryBuilder.fuzzyRewrite(matchQueryFuzzyRewrite);
        }
        if (matchQuery.getMaxExpansions() != null) {
            matchQueryBuilder.maxExpansions(matchQuery.getMaxExpansions().intValue());
        }
        if (Validator.isNotNull((String)matchQuery.getMinShouldMatch())) {
            matchQueryBuilder.minimumShouldMatch(matchQuery.getMinShouldMatch());
        }
        if (matchQuery.getOperator() != null) {
            Operator operator = this.translate(matchQuery.getOperator());
            matchQueryBuilder.operator(operator);
        }
        if (matchQuery.getPrefixLength() != null) {
            matchQueryBuilder.prefixLength(matchQuery.getPrefixLength().intValue());
        }
        if (matchQuery.getZeroTermsQuery() != null) {
            MatchQuery.ZeroTermsQuery matchQueryBuilderZeroTermsQuery = this.translate(matchQuery.getZeroTermsQuery());
            matchQueryBuilder.zeroTermsQuery(matchQueryBuilderZeroTermsQuery);
        }
        if (!matchQuery.isDefaultBoost()) {
            matchQueryBuilder.boost(matchQuery.getBoost());
        }
        if (matchQuery.isFuzzyTranspositions() != null) {
            matchQueryBuilder.fuzzyTranspositions(matchQuery.isFuzzyTranspositions().booleanValue());
        }
        if (matchQuery.isLenient() != null) {
            matchQueryBuilder.lenient(matchQuery.isLenient().booleanValue());
        }
        return matchQueryBuilder;
    }
}

