/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.groupby;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GeoDistanceSort;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch6.internal.groupby.GroupByTranslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={GroupByTranslator.class})
public class DefaultGroupByTranslator
implements GroupByTranslator {
    @Override
    public void translate(SearchRequestBuilder searchRequestBuilder, SearchContext searchContext, int start, int end) {
        GroupBy groupBy = searchContext.getGroupBy();
        TermsAggregationBuilder termsAggregationBuilder = AggregationBuilders.terms((String)("GroupBy_" + groupBy.getField()));
        termsAggregationBuilder = (TermsAggregationBuilder)termsAggregationBuilder.field(groupBy.getField());
        TopHitsAggregationBuilder topHitsAggregationBuilder = this.getTopHitsBuilder(searchContext, start, end, groupBy);
        termsAggregationBuilder.subAggregation((AggregationBuilder)topHitsAggregationBuilder);
        searchRequestBuilder.addAggregation((AggregationBuilder)termsAggregationBuilder);
    }

    protected void addHighlightedField(TopHitsAggregationBuilder topHitsAggregationBuilder, HighlightBuilder highlightBuilder, QueryConfig queryConfig, String fieldName) {
        highlightBuilder.field(fieldName, queryConfig.getHighlightFragmentSize(), queryConfig.getHighlightSnippetSize());
        String localizedFieldName = Field.getLocalizedName((Locale)queryConfig.getLocale(), (String)fieldName);
        highlightBuilder.field(localizedFieldName, queryConfig.getHighlightFragmentSize(), queryConfig.getHighlightSnippetSize());
        topHitsAggregationBuilder.highlighter(highlightBuilder);
    }

    protected void addHighlights(TopHitsAggregationBuilder topHitsAggregationBuilder, QueryConfig queryConfig) {
        if (!queryConfig.isHighlightEnabled()) {
            return;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (String highlightFieldName : queryConfig.getHighlightFieldNames()) {
            this.addHighlightedField(topHitsAggregationBuilder, highlightBuilder, queryConfig, highlightFieldName);
        }
        highlightBuilder.postTags(new String[]{"</liferay-hl>"});
        highlightBuilder.preTags(new String[]{"<liferay-hl>"});
        highlightBuilder.requireFieldMatch(Boolean.valueOf(queryConfig.isHighlightRequireFieldMatch()));
        topHitsAggregationBuilder.highlighter(highlightBuilder);
    }

    protected void addSorts(TopHitsAggregationBuilder topHitsAggregationBuilder, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>(sorts.length);
        for (Sort sort : sorts) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = Field.getSortFieldName((Sort)sort, (String)"_score"))) continue;
            sortFieldNames.add(sortFieldName);
            SortOrder sortOrder = SortOrder.ASC;
            if (sort.isReverse() || sortFieldName.equals("_score")) {
                sortOrder = SortOrder.DESC;
            }
            ScoreSortBuilder sortBuilder = null;
            if (sortFieldName.equals("_score")) {
                sortBuilder = SortBuilders.scoreSort();
            } else if (sort.getType() == 10) {
                GeoDistanceSort geoDistanceSort = (GeoDistanceSort)sort;
                ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
                for (GeoLocationPoint geoLocationPoint : geoDistanceSort.getGeoLocationPoints()) {
                    geoPoints.add(new GeoPoint(geoLocationPoint.getLatitude(), geoLocationPoint.getLongitude()));
                }
                GeoDistanceSortBuilder geoDistanceSortBuilder = SortBuilders.geoDistanceSort((String)sortFieldName, (GeoPoint[])geoPoints.toArray(new GeoPoint[geoPoints.size()]));
                geoDistanceSortBuilder.geoDistance(GeoDistance.ARC);
                List geoHashes = geoDistanceSort.getGeoHashes();
                if (!geoHashes.isEmpty()) {
                    geoDistanceSort.addGeoHash(geoHashes.toArray(new String[geoHashes.size()]));
                }
                sortBuilder = geoDistanceSortBuilder;
            } else {
                FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)sortFieldName);
                fieldSortBuilder.unmappedType("string");
                sortBuilder = fieldSortBuilder;
            }
            sortBuilder.order(sortOrder);
            topHitsAggregationBuilder.sort((SortBuilder)sortBuilder);
        }
    }

    protected TopHitsAggregationBuilder getTopHitsBuilder(SearchContext searchContext, int start, int end, GroupBy groupBy) {
        TopHitsAggregationBuilder topHitsAggregationBuilder = AggregationBuilders.topHits((String)"_topHits");
        int groupyByStart = groupBy.getStart();
        if (groupyByStart == 0) {
            groupyByStart = start;
        }
        topHitsAggregationBuilder.from(groupyByStart);
        int groupBySize = groupBy.getSize();
        if (groupBySize == 0) {
            groupBySize = end - start + 1;
        }
        topHitsAggregationBuilder.size(groupBySize);
        this.addHighlights(topHitsAggregationBuilder, searchContext.getQueryConfig());
        this.addSorts(topHitsAggregationBuilder, searchContext.getSorts());
        return topHitsAggregationBuilder;
    }
}

