/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.facet;

import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.facet.collector.TermCollector;
import com.liferay.portal.search.elasticsearch6.internal.facet.TermCollectorHolder;
import java.util.List;
import org.elasticsearch.search.aggregations.bucket.range.Range;

public class RangeFacetCollector
implements FacetCollector {
    private final String _fieldName;
    private final TermCollectorHolder _termCollectorHolder;

    public RangeFacetCollector(Range range) {
        this._fieldName = range.getName();
        this._termCollectorHolder = this.getTermCollectorHolder(range);
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public TermCollector getTermCollector(String term) {
        return this._termCollectorHolder.getTermCollector(term);
    }

    public List<TermCollector> getTermCollectors() {
        return this._termCollectorHolder.getTermCollectors();
    }

    protected TermCollectorHolder getTermCollectorHolder(Range range) {
        List buckets = range.getBuckets();
        TermCollectorHolder termCollectorHolder = new TermCollectorHolder(buckets.size());
        for (Range.Bucket bucket : buckets) {
            termCollectorHolder.add(bucket.getKeyAsString(), (int)bucket.getDocCount());
        }
        return termCollectorHolder;
    }
}

