/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.facet;

import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.RangeFacet;
import com.liferay.portal.kernel.search.facet.util.RangeParserUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetProcessorContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;

public class AggregationFilteringFacetProcessorContext
implements FacetProcessorContext {
    private final Map<String, List<QueryBuilder>> _selectionFiltersMap;

    public static FacetProcessorContext newInstance(Collection<Facet> facets) {
        return new AggregationFilteringFacetProcessorContext(AggregationFilteringFacetProcessorContext.getSelectionFiltersMap(facets));
    }

    @Override
    public AggregationBuilder postProcessAggregationBuilder(AggregationBuilder aggregationBuilder) {
        String aggregationName = aggregationBuilder.getName();
        AggregationBuilder superAggregationBuilder = this.getSuperAggregationBuilder(aggregationName);
        if (superAggregationBuilder != null) {
            return superAggregationBuilder.subAggregation(aggregationBuilder);
        }
        return aggregationBuilder;
    }

    protected static List<QueryBuilder> getSelectionFilters(com.liferay.portal.search.facet.Facet facet) {
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        String fieldName = facet.getFieldName();
        if (facet instanceof RangeFacet) {
            for (String value : facet.getSelections()) {
                queryBuilders.add(AggregationFilteringFacetProcessorContext.rangeQuery(fieldName, RangeParserUtil.parserRange((String)value)));
            }
        } else {
            queryBuilders.add((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, (String[])facet.getSelections()));
        }
        return queryBuilders;
    }

    protected static Map<String, List<QueryBuilder>> getSelectionFiltersMap(Collection<Facet> facets) {
        HashMap<String, List<QueryBuilder>> map = new HashMap<String, List<QueryBuilder>>();
        for (Facet facet : facets) {
            com.liferay.portal.search.facet.Facet facet2;
            if (!(facet instanceof com.liferay.portal.search.facet.Facet) || facet.isStatic() || ArrayUtil.isEmpty((Object[])(facet2 = (com.liferay.portal.search.facet.Facet)facet).getSelections())) continue;
            map.put(facet2.getAggregationName(), AggregationFilteringFacetProcessorContext.getSelectionFilters(facet2));
        }
        return map;
    }

    protected static QueryBuilder rangeQuery(String fieldName, String[] ranges) {
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)fieldName);
        rangeQueryBuilder.gte((Object)ranges[0]);
        rangeQueryBuilder.lte((Object)ranges[1]);
        return rangeQueryBuilder;
    }

    protected BoolQueryBuilder getSelectionFiltersOfOthersAsBoolQueryBuilder(String aggregationName) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (Map.Entry<String, List<QueryBuilder>> entry : this._selectionFiltersMap.entrySet()) {
            String filterAggregationName = entry.getKey();
            List<QueryBuilder> queryBuilders = entry.getValue();
            if (filterAggregationName.equals(aggregationName)) continue;
            for (QueryBuilder queryBuilder : queryBuilders) {
                boolQueryBuilder.must(queryBuilder);
            }
        }
        return boolQueryBuilder;
    }

    protected AggregationBuilder getSuperAggregationBuilder(String aggregationName) {
        if (this._selectionFiltersMap.isEmpty()) {
            return null;
        }
        BoolQueryBuilder boolQueryBuilder = this.getSelectionFiltersOfOthersAsBoolQueryBuilder(aggregationName);
        if (!boolQueryBuilder.hasClauses()) {
            return null;
        }
        return new FilterAggregationBuilder(aggregationName, (QueryBuilder)boolQueryBuilder);
    }

    private AggregationFilteringFacetProcessorContext(Map<String, List<QueryBuilder>> selectionFiltersMap) {
        this._selectionFiltersMap = selectionFiltersMap;
    }
}

