/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.cluster;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch6.internal.cluster.ReplicasManager;
import com.liferay.portal.search.elasticsearch6.internal.util.LogUtil;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.settings.Settings;

public class ReplicasManagerImpl
implements ReplicasManager {
    private static final Log _log = LogFactoryUtil.getLog(ReplicasManagerImpl.class);
    private final IndicesAdminClient _indicesAdminClient;

    public ReplicasManagerImpl(IndicesAdminClient indicesAdminClient) {
        this._indicesAdminClient = indicesAdminClient;
    }

    @Override
    public void updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
        block2: {
            UpdateSettingsRequestBuilder updateSettingsRequestBuilder = this._indicesAdminClient.prepareUpdateSettings(indices);
            Settings.Builder builder = Settings.builder();
            builder.put("number_of_replicas", numberOfReplicas);
            updateSettingsRequestBuilder.setSettings(builder);
            try {
                UpdateSettingsResponse updateSettingsResponse = (UpdateSettingsResponse)updateSettingsRequestBuilder.get();
                LogUtil.logActionResponse(_log, (ActionResponse)updateSettingsResponse);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)"Unable to update number of replicas", (Throwable)e);
            }
        }
    }
}

