/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.SearchHitsProcessor;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import com.liferay.portal.search.elasticsearch6.internal.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.ClearScrollRequestBuilder;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;

public class SearchResponseScroller {
    private static final Log _log = LogFactoryUtil.getLog(SearchResponseScroller.class);
    private final Client _client;
    private final IndexNameBuilder _indexNameBuilder;
    private final List<String> _previousScrollIds = new ArrayList<String>();
    private final QueryBuilder _queryBuilder;
    private String _scrollId;
    private final TimeValue _scrollTimeValue;
    private final SearchContext _searchContext;
    private final String[] _types;

    public SearchResponseScroller(Client client, SearchContext searchContext, IndexNameBuilder indexNameBuilder, QueryBuilder queryBuilder, TimeValue scrollTimeValue, String ... types) {
        this._client = client;
        this._searchContext = searchContext;
        this._indexNameBuilder = indexNameBuilder;
        this._queryBuilder = queryBuilder;
        this._scrollTimeValue = scrollTimeValue;
        this._types = types;
    }

    public boolean close() {
        try {
            ClearScrollRequestBuilder clearScrollRequestBuilder = this._client.prepareClearScroll();
            clearScrollRequestBuilder.setScrollIds(this._previousScrollIds);
            ClearScrollResponse clearScrollResponse = (ClearScrollResponse)clearScrollRequestBuilder.get();
            LogUtil.logActionResponse(_log, (ActionResponse)clearScrollResponse);
            return clearScrollResponse.isSucceeded();
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
            return false;
        }
    }

    public void prepare() throws Exception {
        SearchRequestBuilder searchRequestBuilder = this._client.prepareSearch(new String[]{this._indexNameBuilder.getIndexName(this._searchContext.getCompanyId())});
        searchRequestBuilder.addSort("_doc", SortOrder.ASC);
        searchRequestBuilder.addStoredField("uid");
        searchRequestBuilder.setQuery(this._queryBuilder);
        searchRequestBuilder.setTypes(this._types);
        Scroll scroll = new Scroll(this._scrollTimeValue);
        searchRequestBuilder.setScroll(scroll);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        this._scrollId = searchResponse.getScrollId();
        LogUtil.logActionResponse(_log, (ActionResponse)searchResponse);
    }

    public boolean scroll(SearchHitsProcessor searchHitsProcessor) throws Exception {
        if (Validator.isNull((String)this._scrollId)) {
            return false;
        }
        SearchScrollRequestBuilder searchScrollRequestBuilder = this._client.prepareSearchScroll(this._scrollId);
        Scroll scroll = new Scroll(this._scrollTimeValue);
        searchScrollRequestBuilder.setScroll(scroll);
        SearchResponse searchResponse = (SearchResponse)searchScrollRequestBuilder.get();
        LogUtil.logActionResponse(_log, (ActionResponse)searchResponse);
        this._previousScrollIds.add(this._scrollId);
        SearchHits searchHits = searchResponse.getHits();
        Object[] searchHitsArray = searchHits.getHits();
        if (ArrayUtil.isEmpty((Object[])searchHitsArray)) {
            this._scrollId = null;
            return false;
        }
        searchHitsProcessor.processSearchHits(this._searchContext, searchHits);
        this._scrollId = searchResponse.getScrollId();
        return true;
    }
}

