/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseSearchEngine;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexFactory;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import com.liferay.portal.search.elasticsearch6.internal.util.LogUtil;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequestBuilder;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryResponse;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.id=SYSTEM_ENGINE", "search.engine.impl=Elasticsearch"}, service={ElasticsearchSearchEngine.class, SearchEngine.class})
public class ElasticsearchSearchEngine
extends BaseSearchEngine {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected IndexFactory indexFactory;
    @Reference
    protected IndexNameBuilder indexNameBuilder;
    private static final String _BACKUP_REPOSITORY_NAME = "liferay_backup";
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchSearchEngine.class);

    public synchronized String backup(long companyId, String backupName) throws SearchException {
        backupName = StringUtil.toLowerCase((String)backupName);
        this.validateBackupName(backupName);
        ClusterAdminClient clusterAdminClient = this.elasticsearchConnectionManager.getClusterAdminClient();
        CreateSnapshotRequestBuilder createSnapshotRequestBuilder = clusterAdminClient.prepareCreateSnapshot(_BACKUP_REPOSITORY_NAME, backupName);
        createSnapshotRequestBuilder.setWaitForCompletion(true);
        try {
            this.createBackupRepository(clusterAdminClient);
            CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)createSnapshotRequestBuilder.get();
            LogUtil.logActionResponse(_log, (ActionResponse)createSnapshotResponse);
            return backupName;
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void initialize(long companyId) {
        super.initialize(companyId);
        this.waitForYellowStatus();
        try {
            this.indexFactory.createIndices(this.elasticsearchConnectionManager.getAdminClient(), companyId);
            this.elasticsearchConnectionManager.registerCompanyId(companyId);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.waitForYellowStatus();
    }

    public synchronized void removeBackup(long companyId, String backupName) throws SearchException {
        ClusterAdminClient clusterAdminClient = this.elasticsearchConnectionManager.getClusterAdminClient();
        try {
            if (!this.hasBackupRepository(clusterAdminClient)) {
                return;
            }
            DeleteSnapshotRequestBuilder deleteSnapshotRequestBuilder = clusterAdminClient.prepareDeleteSnapshot(_BACKUP_REPOSITORY_NAME, backupName);
            DeleteSnapshotResponse deleteSnapshotResponse = (DeleteSnapshotResponse)deleteSnapshotRequestBuilder.get();
            LogUtil.logActionResponse(_log, (ActionResponse)deleteSnapshotResponse);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void removeCompany(long companyId) {
        block2: {
            super.removeCompany(companyId);
            try {
                this.indexFactory.deleteIndices(this.elasticsearchConnectionManager.getAdminClient(), companyId);
                this.elasticsearchConnectionManager.unregisterCompanyId(companyId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to delete index for " + companyId), (Throwable)e);
            }
        }
    }

    public synchronized void restore(long companyId, String backupName) throws SearchException {
        backupName = StringUtil.toLowerCase((String)backupName);
        this.validateBackupName(backupName);
        AdminClient adminClient = this.elasticsearchConnectionManager.getAdminClient();
        IndicesAdminClient indicesAdminClient = adminClient.indices();
        CloseIndexRequestBuilder closeIndexRequestBuilder = indicesAdminClient.prepareClose(new String[]{this.indexNameBuilder.getIndexName(companyId)});
        try {
            CloseIndexResponse closeIndexResponse = (CloseIndexResponse)closeIndexRequestBuilder.get();
            LogUtil.logActionResponse(_log, (ActionResponse)closeIndexResponse);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
        ClusterAdminClient clusterAdminClient = this.elasticsearchConnectionManager.getClusterAdminClient();
        RestoreSnapshotRequestBuilder restoreSnapshotRequestBuilder = clusterAdminClient.prepareRestoreSnapshot(_BACKUP_REPOSITORY_NAME, backupName);
        restoreSnapshotRequestBuilder.setIndices(new String[]{this.indexNameBuilder.getIndexName(companyId)});
        restoreSnapshotRequestBuilder.setWaitForCompletion(true);
        try {
            RestoreSnapshotResponse restoreSnapshotResponse = (RestoreSnapshotResponse)restoreSnapshotRequestBuilder.get();
            LogUtil.logActionResponse(_log, (ActionResponse)restoreSnapshotResponse);
        }
        catch (Exception e) {
            throw new SearchException((Throwable)e);
        }
        this.waitForYellowStatus();
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setIndexSearcher(IndexSearcher indexSearcher) {
        super.setIndexSearcher(indexSearcher);
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setIndexWriter(IndexWriter indexWriter) {
        super.setIndexWriter(indexWriter);
    }

    public void unsetElasticsearchConnectionManager(ElasticsearchConnectionManager elasticsearchConnectionManager) {
        this.elasticsearchConnectionManager = null;
    }

    public void unsetIndexFactory(IndexFactory indexFactory) {
        this.indexFactory = null;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.setVendor(MapUtil.getString(properties, (String)"search.engine.impl"));
    }

    protected void createBackupRepository(ClusterAdminClient clusterAdminClient) throws Exception {
        if (this.hasBackupRepository(clusterAdminClient)) {
            return;
        }
        PutRepositoryRequestBuilder putRepositoryRequestBuilder = clusterAdminClient.preparePutRepository(_BACKUP_REPOSITORY_NAME);
        Settings.Builder builder = Settings.builder();
        builder.put("location", "es_backup");
        putRepositoryRequestBuilder.setSettings(builder);
        putRepositoryRequestBuilder.setType("fs");
        PutRepositoryResponse putRepositoryResponse = (PutRepositoryResponse)putRepositoryRequestBuilder.get();
        LogUtil.logActionResponse(_log, (ActionResponse)putRepositoryResponse);
    }

    protected boolean hasBackupRepository(ClusterAdminClient clusterAdminClient) throws Exception {
        GetRepositoriesRequestBuilder getRepositoriesRequestBuilder = clusterAdminClient.prepareGetRepositories(new String[]{_BACKUP_REPOSITORY_NAME});
        try {
            GetRepositoriesResponse getRepositoriesResponse = (GetRepositoriesResponse)getRepositoriesRequestBuilder.get();
            List repositoryMetaDatas = getRepositoriesResponse.repositories();
            return !repositoryMetaDatas.isEmpty();
        }
        catch (RepositoryMissingException rme) {
            return false;
        }
    }

    protected void validateBackupName(String backupName) throws SearchException {
        if (Validator.isNull((String)backupName)) {
            throw new SearchException("Backup name must not be an empty string");
        }
        if (StringUtil.contains((String)backupName, (String)",")) {
            throw new SearchException("Backup name must not contain comma");
        }
        if (StringUtil.startsWith((String)backupName, (String)"-")) {
            throw new SearchException("Backup name must not start with dash");
        }
        if (StringUtil.contains((String)backupName, (String)"#")) {
            throw new SearchException("Backup name must not contain pounds");
        }
        if (StringUtil.contains((String)backupName, (String)" ")) {
            throw new SearchException("Backup name must not contain spaces");
        }
        if (StringUtil.contains((String)backupName, (String)"\t")) {
            throw new SearchException("Backup name must not contain tabs");
        }
        for (char c : backupName.toCharArray()) {
            if (!Strings.INVALID_FILENAME_CHARS.contains(Character.valueOf(c))) continue;
            throw new SearchException("Backup name must not contain invalid file name characters");
        }
    }

    protected void waitForYellowStatus() {
        ClusterHealthResponse clusterHealthResponse;
        long timeout = 30000L;
        if (PortalRunMode.isTestMode()) {
            timeout = 3600000L;
        }
        if ((clusterHealthResponse = this.elasticsearchConnectionManager.getClusterHealthResponse(timeout)).getStatus() == ClusterHealthStatus.RED) {
            throw new IllegalStateException("Unable to initialize Elasticsearch cluster: " + clusterHealthResponse);
        }
    }
}

