/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexSearcher;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GeoDistanceSort;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterTranslator;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.kernel.search.suggest.QuerySuggester;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch6.internal.SearchHitDocumentTranslator;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.facet.AggregationFilteringFacetProcessorContext;
import com.liferay.portal.search.elasticsearch6.internal.facet.CompositeFacetProcessor;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetCollectorFactory;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetProcessorContext;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetUtil;
import com.liferay.portal.search.elasticsearch6.internal.groupby.GroupByTranslator;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import com.liferay.portal.search.elasticsearch6.internal.stats.StatsTranslator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.time.StopWatch;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration"}, immediate=true, property={"search.engine.impl=Elasticsearch"}, service={IndexSearcher.class})
public class ElasticsearchIndexSearcher
extends BaseIndexSearcher {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference(service=CompositeFacetProcessor.class)
    protected FacetProcessor<SearchRequestBuilder> facetProcessor;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected FilterTranslator<QueryBuilder> filterTranslator;
    @Reference
    protected GroupByTranslator groupByTranslator;
    @Reference
    protected IndexNameBuilder indexNameBuilder;
    @Reference
    protected Props props;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected QueryTranslator<QueryBuilder> queryTranslator;
    @Reference
    protected SearchHitDocumentTranslator searchHitDocumentTranslator;
    @Reference
    protected StatsTranslator statsTranslator;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchIndexSearcher.class);
    private volatile ElasticsearchConfiguration _elasticsearchConfiguration;
    private boolean _logExceptionsOnly;

    public String getQueryString(SearchContext searchContext, Query query) {
        QueryBuilder queryBuilder = (QueryBuilder)this.queryTranslator.translate(query, searchContext);
        return queryBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        Hits hits;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            Document[] documents;
            int start = searchContext.getStart();
            int end = searchContext.getEnd();
            if (start == -1) {
                start = 0;
            } else if (start < 0) {
                throw new IllegalArgumentException("Invalid start " + start);
            }
            if (end == -1) {
                end = GetterUtil.getInteger((String)this.props.get("index.search.limit"));
            } else if (end < 0) {
                throw new IllegalArgumentException("Invalid end " + end);
            }
            Hits hits2 = null;
            while ((documents = (hits2 = this.doSearchHits(searchContext, query, start, end)).getDocs()).length == 0 && start != 0) {
                int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)start, (int)end, (int)hits2.getLength());
                start = startAndEnd[0];
                end = startAndEnd[1];
            }
            hits2.setStart(stopWatch.getStartTime());
            hits = hits2;
        }
        catch (Exception e) {
            HitsImpl hitsImpl;
            try {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e, (Throwable)e);
                }
                if (!this._logExceptionsOnly) {
                    throw new SearchException(e.getMessage(), (Throwable)e);
                }
                hitsImpl = new HitsImpl();
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
            }
            return hitsImpl;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
        }
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long searchCount(SearchContext searchContext, Query query) throws SearchException {
        long l;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            l = this.doSearchCount(searchContext, query);
        }
        catch (Exception e) {
            long l2;
            try {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e, (Throwable)e);
                }
                if (!this._logExceptionsOnly) {
                    throw new SearchException(e.getMessage(), (Throwable)e);
                }
                l2 = 0L;
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
            }
            return l2;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
        }
        return l;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setQuerySuggester(QuerySuggester querySuggester) {
        super.setQuerySuggester(querySuggester);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this._logExceptionsOnly = this._elasticsearchConfiguration.logExceptionsOnly();
    }

    protected void addFacets(SearchRequestBuilder searchRequestBuilder, List<QueryBuilder> queryBuilders, SearchContext searchContext) {
        Map facetsMap = searchContext.getFacets();
        Collection<Facet> facets = facetsMap.values();
        FacetProcessorContext facetProcessorContext = this.getFacetProcessorContext(facets, searchContext);
        for (Facet facet : facets) {
            if (facet.isStatic()) continue;
            this.addFilterQuery(queryBuilders, facet, searchContext);
            Optional<AggregationBuilder> optional = this.facetProcessor.processFacet(facet);
            optional.map(aggregationBuilder -> this.postProcessAggregationBuilder((AggregationBuilder)aggregationBuilder, facetProcessorContext)).ifPresent(arg_0 -> ((SearchRequestBuilder)searchRequestBuilder).addAggregation(arg_0));
        }
    }

    protected void addFilterQuery(List<QueryBuilder> queryBuilders, Facet facet, SearchContext searchContext) {
        BooleanClause booleanClause = facet.getFacetFilterBooleanClause();
        if (booleanClause == null) {
            return;
        }
        QueryBuilder queryBuilder = this.translate((BooleanClause<Filter>)booleanClause, searchContext);
        queryBuilders.add(queryBuilder);
    }

    protected void addGroupBy(SearchRequestBuilder searchRequestBuilder, SearchContext searchContext, int start, int end) {
        GroupBy groupBy = searchContext.getGroupBy();
        if (groupBy == null) {
            return;
        }
        this.groupByTranslator.translate(searchRequestBuilder, searchContext, start, end);
    }

    protected void addHighlightedField(HighlightBuilder highlightBuilder, QueryConfig queryConfig, String fieldName) {
        highlightBuilder.field(fieldName, queryConfig.getHighlightFragmentSize(), queryConfig.getHighlightSnippetSize());
        String localizedFieldName = Field.getLocalizedName((Locale)queryConfig.getLocale(), (String)fieldName);
        highlightBuilder.field(localizedFieldName, queryConfig.getHighlightFragmentSize(), queryConfig.getHighlightSnippetSize());
    }

    protected void addHighlights(SearchRequestBuilder searchRequestBuilder, SearchContext searchContext, QueryConfig queryConfig) {
        if (!queryConfig.isHighlightEnabled()) {
            return;
        }
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (String highlightFieldName : queryConfig.getHighlightFieldNames()) {
            this.addHighlightedField(highlightBuilder, queryConfig, highlightFieldName);
        }
        highlightBuilder.postTags(new String[]{"</liferay-hl>"});
        highlightBuilder.preTags(new String[]{"<liferay-hl>"});
        boolean highlighterRequireFieldMatch = queryConfig.isHighlightRequireFieldMatch();
        boolean luceneSyntax = GetterUtil.getBoolean((Object)searchContext.getAttribute("search.lucene.syntax"));
        if (luceneSyntax) {
            highlighterRequireFieldMatch = false;
        }
        highlightBuilder.requireFieldMatch(Boolean.valueOf(highlighterRequireFieldMatch));
        searchRequestBuilder.highlighter(highlightBuilder);
    }

    protected void addPagination(SearchRequestBuilder searchRequestBuilder, int start, int end) {
        searchRequestBuilder.setFrom(start);
        searchRequestBuilder.setSize(end - start);
    }

    protected void addPreference(SearchRequestBuilder searchRequestBuilder, SearchContext searchContext) {
        String preference = (String)((Object)searchContext.getAttribute("elasticsearch.search.request.preference"));
        if (!Validator.isBlank((String)preference)) {
            searchRequestBuilder.setPreference(preference);
        }
    }

    protected void addSelectedFields(SearchRequestBuilder searchRequestBuilder, QueryConfig queryConfig) {
        Object[] selectedFieldNames = queryConfig.getSelectedFieldNames();
        if (ArrayUtil.isEmpty((Object[])selectedFieldNames)) {
            searchRequestBuilder.addStoredField("*");
        } else {
            searchRequestBuilder.storedFields((String[])selectedFieldNames);
        }
    }

    protected void addSnippets(Document document, Map<String, HighlightField> highlightFields, String fieldName, Locale locale) {
        String snippetFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        HighlightField highlightField = highlightFields.get(snippetFieldName);
        if (highlightField == null) {
            highlightField = highlightFields.get(fieldName);
            snippetFieldName = fieldName;
        }
        if (highlightField == null) {
            return;
        }
        Object[] array = highlightField.fragments();
        document.addText("snippet".concat("_").concat(snippetFieldName), StringUtil.merge((Object[])array, (String)"..."));
    }

    protected void addSnippets(SearchHit hit, Document document, QueryConfig queryConfig) {
        Map highlightFields = hit.getHighlightFields();
        if (MapUtil.isEmpty((Map)highlightFields)) {
            return;
        }
        for (String highlightFieldName : queryConfig.getHighlightFieldNames()) {
            this.addSnippets(document, highlightFields, highlightFieldName, queryConfig.getLocale());
        }
    }

    protected void addSort(SearchRequestBuilder searchRequestBuilder, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>(sorts.length);
        for (Sort sort : sorts) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = this.getSortFieldName(sort, "_score"))) continue;
            sortFieldNames.add(sortFieldName);
            SortOrder sortOrder = SortOrder.ASC;
            if (sort.isReverse() || sortFieldName.equals("_score")) {
                sortOrder = SortOrder.DESC;
            }
            ScoreSortBuilder sortBuilder = null;
            if (sortFieldName.equals("_score")) {
                sortBuilder = SortBuilders.scoreSort();
            } else if (sort.getType() == 10) {
                GeoDistanceSort geoDistanceSort = (GeoDistanceSort)sort;
                ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
                for (GeoLocationPoint geoLocationPoint : geoDistanceSort.getGeoLocationPoints()) {
                    geoPoints.add(new GeoPoint(geoLocationPoint.getLatitude(), geoLocationPoint.getLongitude()));
                }
                GeoDistanceSortBuilder geoDistanceSortBuilder = SortBuilders.geoDistanceSort((String)sortFieldName, (GeoPoint[])geoPoints.toArray(new GeoPoint[geoPoints.size()]));
                geoDistanceSortBuilder.geoDistance(GeoDistance.ARC);
                List geoHashes = geoDistanceSort.getGeoHashes();
                if (!geoHashes.isEmpty()) {
                    geoDistanceSort.addGeoHash(geoHashes.toArray(new String[geoHashes.size()]));
                }
                sortBuilder = geoDistanceSortBuilder;
            } else {
                FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)sortFieldName);
                fieldSortBuilder.unmappedType("string");
                sortBuilder = fieldSortBuilder;
            }
            sortBuilder.order(sortOrder);
            searchRequestBuilder.addSort((SortBuilder)sortBuilder);
        }
    }

    protected void addStats(SearchRequestBuilder searchRequestBuilder, SearchContext searchContext) {
        Map statsMap = searchContext.getStats();
        for (Stats stats : statsMap.values()) {
            this.statsTranslator.translate(searchRequestBuilder, stats);
        }
    }

    protected SearchResponse doSearch(SearchContext searchContext, Query query, int start, int end, boolean count) throws Exception {
        Client client = this.elasticsearchConnectionManager.getClient();
        QueryConfig queryConfig = query.getQueryConfig();
        SearchRequestBuilder searchRequestBuilder = client.prepareSearch(this.getSelectedIndexNames(queryConfig, searchContext));
        searchRequestBuilder.setTypes(this.getSelectedTypes(queryConfig));
        this.addStats(searchRequestBuilder, searchContext);
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        if (!count) {
            this.addFacets(searchRequestBuilder, queryBuilders, searchContext);
            this.addGroupBy(searchRequestBuilder, searchContext, start, end);
            this.addHighlights(searchRequestBuilder, searchContext, queryConfig);
            this.addPagination(searchRequestBuilder, start, end);
            this.addPreference(searchRequestBuilder, searchContext);
            this.addSelectedFields(searchRequestBuilder, queryConfig);
            this.addSort(searchRequestBuilder, searchContext.getSorts());
            searchRequestBuilder.setTrackScores(queryConfig.isScoreEnabled());
        } else {
            searchRequestBuilder.setSize(0);
        }
        if (query.getPostFilter() != null) {
            queryBuilders.add((QueryBuilder)this.filterTranslator.translate(query.getPostFilter(), searchContext));
        }
        if (!ListUtil.isEmpty(queryBuilders)) {
            searchRequestBuilder.setPostFilter(this.getPostFilter(queryBuilders));
        }
        QueryBuilder queryBuilder = (QueryBuilder)this.queryTranslator.translate(query, searchContext);
        if (query.getPreBooleanFilter() != null) {
            QueryBuilder preFilterQueryBuilder = (QueryBuilder)this.filterTranslator.translate((Filter)query.getPreBooleanFilter(), searchContext);
            BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.filter(preFilterQueryBuilder);
            boolQueryBuilder.must(queryBuilder);
            queryBuilder = boolQueryBuilder;
        }
        searchRequestBuilder.setQuery(queryBuilder);
        String searchRequestBuilderString = searchRequestBuilder.toString();
        searchContext.setAttribute("queryString", (Serializable)((Object)searchRequestBuilderString));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Search query " + searchRequestBuilderString));
        }
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"The search engine processed ", searchRequestBuilderString, " in ", searchResponse.getTook()}));
        }
        return searchResponse;
    }

    protected long doSearchCount(SearchContext searchContext, Query query) throws Exception {
        SearchResponse searchResponse = this.doSearch(searchContext, query, searchContext.getStart(), searchContext.getEnd(), true);
        SearchHits searchHits = searchResponse.getHits();
        return searchHits.getTotalHits();
    }

    protected Hits doSearchHits(SearchContext searchContext, Query query, int start, int end) throws Exception {
        SearchResponse searchResponse = this.doSearch(searchContext, query, start, end, false);
        return this.processResponse(searchResponse, searchContext, query);
    }

    protected FacetCollector getFacetCollector(Facet facet, Map<String, Aggregation> aggregationsMap) {
        FacetCollectorFactory facetCollectorFactory = new FacetCollectorFactory();
        return facetCollectorFactory.getFacetCollector(aggregationsMap.get(FacetUtil.getAggregationName(facet)));
    }

    protected FacetProcessorContext getFacetProcessorContext(Collection<Facet> facets, SearchContext searchContext) {
        boolean basicFacetSelection = GetterUtil.getBoolean((Object)searchContext.getAttribute("search.basic.facet.selection"));
        if (basicFacetSelection) {
            return null;
        }
        return AggregationFilteringFacetProcessorContext.newInstance(facets);
    }

    protected QueryBuilder getPostFilter(List<QueryBuilder> queryBuilders) {
        if (queryBuilders.size() == 1) {
            return queryBuilders.get(0);
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (QueryBuilder queryBuilder : queryBuilders) {
            boolQueryBuilder.must(queryBuilder);
        }
        return boolQueryBuilder;
    }

    protected String[] getSelectedIndexNames(QueryConfig queryConfig, SearchContext searchContext) {
        Object[] selectedIndexNames = queryConfig.getSelectedIndexNames();
        if (ArrayUtil.isNotEmpty((Object[])selectedIndexNames)) {
            return selectedIndexNames;
        }
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        return new String[]{indexName};
    }

    protected String[] getSelectedTypes(QueryConfig queryConfig) {
        Object[] selectedTypes = queryConfig.getSelectedTypes();
        if (ArrayUtil.isNotEmpty((Object[])selectedTypes)) {
            return selectedTypes;
        }
        return new String[]{"LiferayDocumentType"};
    }

    protected String getSortFieldName(Sort sort, String scoreFieldName) {
        String sortFieldName = sort.getFieldName();
        if (Objects.equals(sortFieldName, "priority")) {
            return sortFieldName;
        }
        return Field.getSortFieldName((Sort)sort, (String)scoreFieldName);
    }

    protected AggregationBuilder postProcessAggregationBuilder(AggregationBuilder aggregationBuilder, FacetProcessorContext facetProcessorContext) {
        if (facetProcessorContext != null) {
            return facetProcessorContext.postProcessAggregationBuilder(aggregationBuilder);
        }
        return aggregationBuilder;
    }

    protected Hits processResponse(SearchResponse searchResponse, SearchContext searchContext, Query query) {
        SearchHits searchHits = searchResponse.getHits();
        HitsImpl hits = new HitsImpl();
        this.updateFacetCollectors(searchContext, searchResponse);
        this.updateGroupedHits(searchResponse, searchContext, query, (Hits)hits);
        this.updateStatsResults(searchContext, searchResponse, (Hits)hits);
        TimeValue timeValue = searchResponse.getTook();
        hits.setSearchTime((float)timeValue.getSecondsFrac());
        return this.processSearchHits(searchHits, query, (Hits)hits);
    }

    protected Document processSearchHit(SearchHit searchHit, QueryConfig queryConfig) {
        Document document = this.searchHitDocumentTranslator.translate(searchHit);
        this.populateUID(document, queryConfig);
        return document;
    }

    protected Hits processSearchHits(SearchHits searchHits, Query query, Hits hits) {
        ArrayList<Document> documents = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        if (searchHits.getTotalHits() > 0L) {
            SearchHit[] searchHitsArray;
            for (SearchHit searchHit : searchHitsArray = searchHits.getHits()) {
                Document document = this.processSearchHit(searchHit, query.getQueryConfig());
                documents.add(document);
                scores.add(Float.valueOf(searchHit.getScore()));
                this.addSnippets(searchHit, document, query.getQueryConfig());
            }
        }
        hits.setDocs(documents.toArray(new Document[documents.size()]));
        hits.setLength((int)searchHits.getTotalHits());
        hits.setQuery(query);
        hits.setQueryTerms(new String[0]);
        hits.setScores(ArrayUtil.toFloatArray(scores));
        return hits;
    }

    protected QueryBuilder translate(BooleanClause<Filter> booleanClause, SearchContext searchContext) {
        BooleanFilter booleanFilter = new BooleanFilter();
        booleanFilter.add((Filter)booleanClause.getClause(), booleanClause.getBooleanClauseOccur());
        return (QueryBuilder)this.filterTranslator.translate((Filter)booleanFilter, searchContext);
    }

    protected void updateFacetCollectors(SearchContext searchContext, SearchResponse searchResponse) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return;
        }
        Map aggregationsMap = aggregations.getAsMap();
        Map facetsMap = searchContext.getFacets();
        for (Facet facet : facetsMap.values()) {
            if (facet.isStatic()) continue;
            facet.setFacetCollector(this.getFacetCollector(facet, aggregationsMap));
        }
    }

    protected void updateGroupedHits(SearchResponse searchResponse, SearchContext searchContext, Query query, Hits hits) {
        GroupBy groupBy = searchContext.getGroupBy();
        if (groupBy == null) {
            return;
        }
        Aggregations aggregations = searchResponse.getAggregations();
        Map aggregationsMap = aggregations.getAsMap();
        Terms terms = (Terms)aggregationsMap.get("GroupBy_" + groupBy.getField());
        List buckets = terms.getBuckets();
        for (Terms.Bucket bucket : buckets) {
            Aggregations bucketAggregations = bucket.getAggregations();
            TopHits topHits = (TopHits)bucketAggregations.get("_topHits");
            SearchHits groupedSearchHits = topHits.getHits();
            HitsImpl groupedHits = new HitsImpl();
            this.processSearchHits(groupedSearchHits, query, (Hits)groupedHits);
            groupedHits.setLength((int)groupedSearchHits.getTotalHits());
            hits.addGroupedHits(bucket.getKeyAsString(), (Hits)groupedHits);
        }
    }

    protected void updateStatsResults(SearchContext searchContext, SearchResponse searchResponse, Hits hits) {
        Map statsMap = searchContext.getStats();
        if (statsMap.isEmpty()) {
            return;
        }
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return;
        }
        Map aggregationsMap = aggregations.getAsMap();
        for (Stats stats : statsMap.values()) {
            if (!stats.isEnabled()) continue;
            StatsResults statsResults = this.statsTranslator.translate(aggregationsMap, stats);
            hits.addStatsResults(statsResults);
        }
    }
}

