/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.util;

import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class ResourceUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getResourceAsString(Class<?> clazz, String resourceName) {
        try (InputStream inputStream = clazz.getResourceAsStream(resourceName);){
            String string = StringUtil.read((InputStream)inputStream);
            return string;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to load resource: " + resourceName, ioe);
        }
    }

    public static File getResourceAsTempFile(Class<?> clazz, String name) throws IOException {
        int index = name.lastIndexOf(46);
        File file = File.createTempFile(name.substring(0, index), name.substring(index));
        file.deleteOnExit();
        try (InputStream inputStream = clazz.getResourceAsStream(name);){
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
        }
        return file;
    }
}

