/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.suggest;

import com.liferay.portal.kernel.search.suggest.Suggester;
import org.elasticsearch.search.suggest.SortBy;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;

public abstract class BaseSuggesterTranslatorImpl {
    protected String translate(Suggester.Sort sort) {
        if (sort == Suggester.Sort.FREQUENCY) {
            return "frequency";
        }
        return "score";
    }

    protected String translate(Suggester.StringDistance stringDistance) {
        if (stringDistance == Suggester.StringDistance.DAMERAU_LEVENSHTEIN) {
            return "damerau_levnshtein";
        }
        if (stringDistance == Suggester.StringDistance.JAROWINKLER) {
            return "jarowinkler";
        }
        if (stringDistance == Suggester.StringDistance.LEVENSTEIN) {
            return "levenstein";
        }
        if (stringDistance == Suggester.StringDistance.NGRAM) {
            return "ngram";
        }
        return "internal";
    }

    protected String translate(Suggester.SuggestMode suggestMode) {
        if (suggestMode == Suggester.SuggestMode.ALWAYS) {
            return "always";
        }
        if (suggestMode == Suggester.SuggestMode.POPULAR) {
            return "popular";
        }
        return "missing";
    }

    protected TermSuggestionBuilder.StringDistanceImpl translateDistance(Suggester.StringDistance stringDistance) {
        if (stringDistance == Suggester.StringDistance.DAMERAU_LEVENSHTEIN) {
            return TermSuggestionBuilder.StringDistanceImpl.DAMERAU_LEVENSHTEIN;
        }
        if (stringDistance == Suggester.StringDistance.JAROWINKLER) {
            return TermSuggestionBuilder.StringDistanceImpl.JARO_WINKLER;
        }
        if (stringDistance == Suggester.StringDistance.LEVENSTEIN) {
            return TermSuggestionBuilder.StringDistanceImpl.LEVENSHTEIN;
        }
        if (stringDistance == Suggester.StringDistance.NGRAM) {
            return TermSuggestionBuilder.StringDistanceImpl.NGRAM;
        }
        return TermSuggestionBuilder.StringDistanceImpl.INTERNAL;
    }

    protected TermSuggestionBuilder.SuggestMode translateMode(Suggester.SuggestMode suggestMode) {
        if (suggestMode == Suggester.SuggestMode.ALWAYS) {
            return TermSuggestionBuilder.SuggestMode.ALWAYS;
        }
        if (suggestMode == Suggester.SuggestMode.POPULAR) {
            return TermSuggestionBuilder.SuggestMode.POPULAR;
        }
        return TermSuggestionBuilder.SuggestMode.MISSING;
    }

    protected SortBy translateSort(Suggester.Sort sort) {
        if (sort == Suggester.Sort.FREQUENCY) {
            return SortBy.FREQUENCY;
        }
        return SortBy.SCORE;
    }
}

