/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotDetails;
import com.liferay.portal.search.engine.adapter.snapshot.SnapshotState;
import java.util.List;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;

public class SnapshotInfoConverter {
    public static SnapshotState convert(org.elasticsearch.snapshots.SnapshotState snapshotState) {
        if (snapshotState.value() == 0) {
            return SnapshotState.IN_PROGRESS;
        }
        if (snapshotState.value() == 1) {
            return SnapshotState.SUCCESS;
        }
        if (snapshotState.value() == 2) {
            return SnapshotState.FAILED;
        }
        if (snapshotState.value() == 3) {
            return SnapshotState.PARTIAL;
        }
        if (snapshotState.value() == 4) {
            return SnapshotState.INCOMPATIBLE;
        }
        throw new IllegalArgumentException("Invalid value for snapshot state: " + snapshotState);
    }

    public static SnapshotDetails convert(SnapshotInfo snapshotInfo) {
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        SnapshotDetails snapshotDetails = new SnapshotDetails(snapshotId.getName(), snapshotId.getUUID());
        List indices = snapshotInfo.indices();
        if (ListUtil.isNotEmpty((List)indices)) {
            snapshotDetails.setIndexNames(indices.toArray(new String[indices.size()]));
        }
        SnapshotState snapshotState = SnapshotInfoConverter.convert(snapshotInfo.state());
        snapshotDetails.setSnapshotState(snapshotState);
        snapshotDetails.setSuccessfulShards(snapshotInfo.successfulShards());
        snapshotDetails.setTotalShards(snapshotInfo.totalShards());
        return snapshotDetails;
    }
}

