/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.snapshot.RestoreSnapshotRequestExecutor;
import com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotRequest;
import java.util.List;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotAction;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequestBuilder;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.snapshots.RestoreInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={RestoreSnapshotRequestExecutor.class})
public class RestoreSnapshotRequestExecutorImpl
implements RestoreSnapshotRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotResponse execute(RestoreSnapshotRequest restoreSnapshotRequest) {
        RestoreSnapshotRequestBuilder restoreSnapshotRequestBuilder = this.createRestoreSnapshotRequestBuilder(restoreSnapshotRequest);
        RestoreSnapshotResponse elasticsearchRestoreSnapshotResponse = (RestoreSnapshotResponse)restoreSnapshotRequestBuilder.get();
        RestoreInfo restoreInfo = elasticsearchRestoreSnapshotResponse.getRestoreInfo();
        List indexNames = restoreInfo.indices();
        com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotResponse restoreSnapshotResponse = new com.liferay.portal.search.engine.adapter.snapshot.RestoreSnapshotResponse(restoreInfo.name(), indexNames.toArray(new String[indexNames.size()]), restoreInfo.totalShards(), restoreInfo.failedShards());
        return restoreSnapshotResponse;
    }

    protected RestoreSnapshotRequestBuilder createRestoreSnapshotRequestBuilder(RestoreSnapshotRequest restoreSnapshotRequest) {
        RestoreSnapshotRequestBuilder restoreSnapshotRequestBuilder = RestoreSnapshotAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.elasticsearchConnectionManager.getClient());
        restoreSnapshotRequestBuilder.setIncludeAliases(restoreSnapshotRequest.isIncludeAliases());
        restoreSnapshotRequestBuilder.setIndices(restoreSnapshotRequest.getIndexNames());
        restoreSnapshotRequestBuilder.setPartial(restoreSnapshotRequest.isPartialRestore());
        if (Validator.isNotNull((String)restoreSnapshotRequest.getRenameReplacement())) {
            restoreSnapshotRequestBuilder.setRenameReplacement(restoreSnapshotRequest.getRenameReplacement());
        }
        if (Validator.isNotNull((String)restoreSnapshotRequest.getRenamePattern())) {
            restoreSnapshotRequestBuilder.setRenamePattern(restoreSnapshotRequest.getRenamePattern());
        }
        restoreSnapshotRequestBuilder.setRepository(restoreSnapshotRequest.getRepositoryName());
        restoreSnapshotRequestBuilder.setRestoreGlobalState(restoreSnapshotRequest.isRestoreGlobalState());
        restoreSnapshotRequestBuilder.setSnapshot(restoreSnapshotRequest.getSnapshotName());
        restoreSnapshotRequestBuilder.setWaitForCompletion(restoreSnapshotRequest.isWaitForCompletion());
        return restoreSnapshotRequestBuilder;
    }
}

