/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchSearchRequestExecutor.class})
public class SearchSearchRequestExecutorImpl
implements SearchSearchRequestExecutor {
    protected static final String ZERO_TERMS_QUERY_STRING = ",\"zero_terms_query\":\"NONE\"";
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected SearchSearchRequestAssembler searchSearchRequestAssembler;
    @Reference
    protected SearchSearchResponseAssembler searchSearchResponseAssembler;

    @Override
    public SearchSearchResponse execute(SearchSearchRequest searchSearchRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        SearchRequestBuilder searchRequestBuilder = SearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        this.searchSearchRequestAssembler.assemble(searchRequestBuilder, searchSearchRequest);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        SearchSearchResponse searchSearchResponse = new SearchSearchResponse();
        String searchRequestBuilderString = searchRequestBuilder.toString();
        searchRequestBuilderString = StringUtil.replace((String)searchRequestBuilderString, (String)ZERO_TERMS_QUERY_STRING, (String)"");
        this.searchSearchResponseAssembler.assemble(searchResponse, searchSearchResponse, searchSearchRequest, searchRequestBuilderString);
        return searchSearchResponse;
    }
}

