/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CommonSearchRequestBuilderAssembler;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CommonSearchResponseAssembler;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CountSearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.BaseSearchResponse;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.search.SearchHits;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CountSearchRequestExecutor.class})
public class CountSearchRequestExecutorImpl
implements CountSearchRequestExecutor {
    @Reference
    protected CommonSearchRequestBuilderAssembler commonSearchRequestBuilderAssembler;
    @Reference
    protected CommonSearchResponseAssembler commonSearchResponseAssembler;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public CountSearchResponse execute(CountSearchRequest countSearchRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        SearchRequestBuilder searchRequestBuilder = SearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        this.commonSearchRequestBuilderAssembler.assemble(searchRequestBuilder, (BaseSearchRequest)countSearchRequest);
        searchRequestBuilder.setSize(0);
        searchRequestBuilder.setTrackScores(false);
        SearchResponse searchResponse = (SearchResponse)searchRequestBuilder.get();
        SearchHits searchHits = searchResponse.getHits();
        CountSearchResponse countSearchResponse = new CountSearchResponse();
        countSearchResponse.setCount(searchHits.totalHits);
        String searchRequestBuilderString = searchRequestBuilder.toString();
        this.commonSearchResponseAssembler.assemble(searchResponse, (BaseSearchResponse)countSearchResponse, searchRequestBuilderString);
        return countSearchResponse;
    }
}

