/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.UpdateIndexSettingsIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesOptions;
import com.liferay.portal.search.engine.adapter.index.UpdateIndexSettingsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.UpdateIndexSettingsIndexResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UpdateIndexSettingsIndexRequestExecutor.class})
public class UpdateIndexSettingsIndexRequestExecutorImpl
implements UpdateIndexSettingsIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected IndicesOptionsTranslator indicesOptionsTranslator;

    @Override
    public UpdateIndexSettingsIndexResponse execute(UpdateIndexSettingsIndexRequest updateIndexSettingsIndexRequest) {
        UpdateSettingsRequestBuilder updateSettingsRequestBuilder = this.createUpdateSettingsRequestBuilder(updateIndexSettingsIndexRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)updateSettingsRequestBuilder.get();
        return new UpdateIndexSettingsIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected UpdateSettingsRequestBuilder createUpdateSettingsRequestBuilder(UpdateIndexSettingsIndexRequest updateIndexSettingsIndexRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        UpdateSettingsRequestBuilder updateSettingsRequestBuilder = UpdateSettingsAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        updateSettingsRequestBuilder.setIndices(updateIndexSettingsIndexRequest.getIndexNames());
        updateSettingsRequestBuilder.setSettings(updateIndexSettingsIndexRequest.getSettings(), XContentType.JSON);
        IndicesOptions indicesOptions = updateIndexSettingsIndexRequest.getIndicesOptions();
        if (indicesOptions != null) {
            updateSettingsRequestBuilder.setIndicesOptions(this.indicesOptionsTranslator.translate(indicesOptions));
        }
        return updateSettingsRequestBuilder;
    }
}

