/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.PutMappingIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.PutMappingIndexRequest;
import com.liferay.portal.search.engine.adapter.index.PutMappingIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PutMappingIndexRequestExecutor.class})
public class PutMappingIndexRequestExecutorImpl
implements PutMappingIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public PutMappingIndexResponse execute(PutMappingIndexRequest putMappingIndexRequest) {
        PutMappingRequestBuilder putMappingRequestBuilder = this.createPutMappingRequestBuilder(putMappingIndexRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)putMappingRequestBuilder.get();
        return new PutMappingIndexResponse(Boolean.valueOf(acknowledgedResponse.isAcknowledged()));
    }

    protected PutMappingRequestBuilder createPutMappingRequestBuilder(PutMappingIndexRequest putMappingIndexRequest) {
        AdminClient adminClient = this.elasticsearchConnectionManager.getAdminClient();
        IndicesAdminClient indicesAdminClient = adminClient.indices();
        PutMappingRequestBuilder putMappingRequestBuilder = indicesAdminClient.preparePutMapping(putMappingIndexRequest.getIndexNames());
        putMappingRequestBuilder.setSource(putMappingIndexRequest.getMapping(), XContentType.JSON);
        putMappingRequestBuilder.setType(putMappingIndexRequest.getMappingName());
        return putMappingRequestBuilder;
    }
}

