/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.OpenIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesOptions;
import com.liferay.portal.search.engine.adapter.index.OpenIndexRequest;
import com.liferay.portal.search.engine.adapter.index.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenIndexRequestExecutor.class})
public class OpenIndexRequestExecutorImpl
implements OpenIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected IndicesOptionsTranslator indicesOptionsTranslator;

    @Override
    public OpenIndexResponse execute(OpenIndexRequest openIndexRequest) {
        OpenIndexRequestBuilder openIndexRequestBuilder = this.createOpenIndexRequestBuilder(openIndexRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)openIndexRequestBuilder.get();
        OpenIndexResponse openIndexResponse = new OpenIndexResponse(acknowledgedResponse.isAcknowledged());
        return openIndexResponse;
    }

    protected OpenIndexRequestBuilder createOpenIndexRequestBuilder(OpenIndexRequest openIndexRequest) {
        OpenIndexRequestBuilder openIndexRequestBuilder = OpenIndexAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.elasticsearchConnectionManager.getClient());
        openIndexRequestBuilder.setIndices(openIndexRequest.getIndexNames());
        IndicesOptions indicesOptions = openIndexRequest.getIndicesOptions();
        if (indicesOptions != null) {
            openIndexRequestBuilder.setIndicesOptions(this.indicesOptionsTranslator.translate(indicesOptions));
        }
        if (openIndexRequest.getTimeout() > 0L) {
            TimeValue timeValue = TimeValue.timeValueMillis((long)openIndexRequest.getTimeout());
            openIndexRequestBuilder.setMasterNodeTimeout(timeValue);
            openIndexRequestBuilder.setTimeout(timeValue);
        }
        if (openIndexRequest.getWaitForActiveShards() > 0) {
            openIndexRequestBuilder.setWaitForActiveShards(openIndexRequest.getWaitForActiveShards());
        }
        return openIndexRequestBuilder;
    }
}

