/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.GetMappingIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.GetMappingIndexRequest;
import com.liferay.portal.search.engine.adapter.index.GetMappingIndexResponse;
import java.util.HashMap;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GetMappingIndexRequestExecutor.class})
public class GetMappingIndexRequestExecutorImpl
implements GetMappingIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public GetMappingIndexResponse execute(GetMappingIndexRequest getMappingIndexRequest) {
        GetMappingsRequestBuilder getMappingsRequestBuilder = this.createGetMappingsRequestBuilder(getMappingIndexRequest);
        GetMappingsResponse getMappingsResponse = (GetMappingsResponse)getMappingsRequestBuilder.get();
        ImmutableOpenMap mappings = getMappingsResponse.mappings();
        HashMap<String, String> indexMappings = new HashMap<String, String>();
        for (String indexName : getMappingIndexRequest.getIndexNames()) {
            ImmutableOpenMap indexMapping = (ImmutableOpenMap)mappings.get((Object)indexName);
            MappingMetaData mappingMetaData = (MappingMetaData)indexMapping.get((Object)getMappingIndexRequest.getMappingName());
            CompressedXContent mappingContent = mappingMetaData.source();
            indexMappings.put(indexName, mappingContent.toString());
        }
        return new GetMappingIndexResponse(indexMappings);
    }

    protected GetMappingsRequestBuilder createGetMappingsRequestBuilder(GetMappingIndexRequest getMappingIndexRequest) {
        AdminClient adminClient = this.elasticsearchConnectionManager.getAdminClient();
        IndicesAdminClient indicesAdminClient = adminClient.indices();
        GetMappingsRequestBuilder getMappingsRequestBuilder = indicesAdminClient.prepareGetMappings(getMappingIndexRequest.getIndexNames());
        getMappingsRequestBuilder.setTypes(new String[]{getMappingIndexRequest.getMappingName()});
        return getMappingsRequestBuilder;
    }
}

