/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.DeleteIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexRequest;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DeleteIndexRequestExecutor.class})
public class DeleteIndexRequestExecutorImpl
implements DeleteIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected IndicesOptionsTranslator indicesOptionsTranslator;

    @Override
    public DeleteIndexResponse execute(DeleteIndexRequest deleteIndexRequest) {
        DeleteIndexRequestBuilder deleteIndexRequestBuilder = this.createDeleteIndexRequestBuilder(deleteIndexRequest);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)deleteIndexRequestBuilder.get();
        return new DeleteIndexResponse(acknowledgedResponse.isAcknowledged());
    }

    protected DeleteIndexRequestBuilder createDeleteIndexRequestBuilder(DeleteIndexRequest deleteIndexRequest) {
        AdminClient adminClient = this.elasticsearchConnectionManager.getAdminClient();
        IndicesAdminClient indicesAdminClient = adminClient.indices();
        DeleteIndexRequestBuilder deleteIndexRequestBuilder = indicesAdminClient.prepareDelete(deleteIndexRequest.getIndexNames());
        IndicesOptions indicesOptions = this.indicesOptionsTranslator.translate(deleteIndexRequest.getIndicesOptions());
        deleteIndexRequestBuilder.setIndicesOptions(indicesOptions);
        return deleteIndexRequestBuilder;
    }
}

