/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster.ClusterHealthStatusTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster.StatsClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.StatsClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.StatsClusterResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsAction;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StatsClusterRequestExecutor.class})
public class StatsClusterRequestExecutorImpl
implements StatsClusterRequestExecutor {
    @Reference
    protected ClusterHealthStatusTranslator clusterHealthStatusTranslator;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public StatsClusterResponse execute(StatsClusterRequest statsClusterRequest) {
        ClusterStatsRequestBuilder clusterStatsRequestBuilder = this.createClusterStatsRequestBuilder(statsClusterRequest);
        ClusterStatsResponse clusterStatsResponse = (ClusterStatsResponse)clusterStatsRequestBuilder.get();
        try {
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            xContentBuilder.startObject();
            xContentBuilder = clusterStatsResponse.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            xContentBuilder.endObject();
            ClusterHealthStatus clusterHealthStatus = clusterStatsResponse.getStatus();
            StatsClusterResponse statsClusterResponse = new StatsClusterResponse(this.clusterHealthStatusTranslator.translate(clusterHealthStatus), Strings.toString((XContentBuilder)xContentBuilder));
            return statsClusterResponse;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected ClusterStatsRequestBuilder createClusterStatsRequestBuilder(StatsClusterRequest statsClusterRequest) {
        ClusterStatsRequestBuilder clusterStatsRequestBuilder = ClusterStatsAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.elasticsearchConnectionManager.getClient());
        return clusterStatsRequestBuilder;
    }
}

