/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster.ClusterHealthStatusTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster.HealthClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.HealthClusterResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthAction;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequestBuilder;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.unit.TimeValue;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={HealthClusterRequestExecutor.class})
public class HealthClusterRequestExecutorImpl
implements HealthClusterRequestExecutor {
    @Reference
    protected ClusterHealthStatusTranslator clusterHealthStatusTranslator;
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public HealthClusterResponse execute(HealthClusterRequest healthClusterRequest) {
        ClusterHealthRequestBuilder clusterHealthRequestBuilder = this.createClusterHealthRequestBuilder(healthClusterRequest);
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)clusterHealthRequestBuilder.get();
        ClusterHealthStatus clusterHealthStatus = clusterHealthResponse.getStatus();
        return new HealthClusterResponse(this.clusterHealthStatusTranslator.translate(clusterHealthStatus), clusterHealthResponse.toString());
    }

    protected ClusterHealthRequestBuilder createClusterHealthRequestBuilder(HealthClusterRequest healthClusterRequest) {
        ClusterHealthRequestBuilder clusterHealthRequestBuilder = ClusterHealthAction.INSTANCE.newRequestBuilder((ElasticsearchClient)this.elasticsearchConnectionManager.getClient());
        clusterHealthRequestBuilder.setIndices(healthClusterRequest.getIndexNames());
        long timeout = healthClusterRequest.getTimeout();
        if (timeout > 0L) {
            clusterHealthRequestBuilder.setMasterNodeTimeout(TimeValue.timeValueMillis((long)timeout));
            clusterHealthRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)timeout));
        }
        if (healthClusterRequest.getWaitForClusterHealthStatus() != null) {
            clusterHealthRequestBuilder.setWaitForStatus(this.clusterHealthStatusTranslator.translate(healthClusterRequest.getWaitForClusterHealthStatus()));
        }
        return clusterHealthRequestBuilder;
    }
}

