/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.highlight;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.search.elasticsearch6.internal.highlight.HighlighterTranslator;
import java.util.Locale;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.osgi.service.component.annotations.Component;

@Component(service={HighlighterTranslator.class})
public class DefaultHighlighterTranslator
implements HighlighterTranslator {
    @Override
    public void translate(SearchRequestBuilder searchRequestBuilder, Locale locale, String[] highlightFieldNames, boolean highlightRequireFieldMatch, int highlightFragmentSize, int highlightSnippetSize, boolean luceneSyntax) {
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (String highlightFieldName : highlightFieldNames) {
            this.addHighlightedField(highlightBuilder, highlightFieldName, locale, highlightFragmentSize, highlightSnippetSize);
        }
        highlightBuilder.postTags(new String[]{"</liferay-hl>"});
        highlightBuilder.preTags(new String[]{"<liferay-hl>"});
        if (luceneSyntax) {
            highlightRequireFieldMatch = false;
        }
        highlightBuilder.requireFieldMatch(Boolean.valueOf(highlightRequireFieldMatch));
        searchRequestBuilder.highlighter(highlightBuilder);
    }

    protected void addHighlightedField(HighlightBuilder highlightBuilder, String fieldName, Locale locale, int highlightFragmentSize, int highlightSnippetSize) {
        highlightBuilder.field(fieldName, highlightFragmentSize, highlightSnippetSize);
        String localizedFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        highlightBuilder.field(localizedFieldName, highlightFragmentSize, highlightSnippetSize);
    }
}

