/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.groupby;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GeoDistanceSort;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch6.internal.groupby.GroupByTranslator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregationBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={GroupByTranslator.class})
public class DefaultGroupByTranslator
implements GroupByTranslator {
    @Override
    public void translate(SearchRequestBuilder searchRequestBuilder, GroupBy groupBy, Sort[] sorts, Locale locale, String[] selectedFieldNames, String[] highlightFieldNames, boolean highlightEnabled, boolean highlightRequireFieldMatch, int highlightFragmentSize, int highlightSnippetSize, int start, int size) {
        TermsAggregationBuilder termsAggregationBuilder = AggregationBuilders.terms((String)("GroupBy_" + groupBy.getField()));
        termsAggregationBuilder = (TermsAggregationBuilder)termsAggregationBuilder.field(groupBy.getField());
        TopHitsAggregationBuilder topHitsAggregationBuilder = this.getTopHitsBuilder(groupBy, sorts, selectedFieldNames, locale, highlightFieldNames, highlightEnabled, highlightRequireFieldMatch, highlightFragmentSize, highlightSnippetSize, start, size);
        termsAggregationBuilder.subAggregation((AggregationBuilder)topHitsAggregationBuilder);
        searchRequestBuilder.addAggregation((AggregationBuilder)termsAggregationBuilder);
    }

    protected void addHighlightedField(TopHitsAggregationBuilder topHitsAggregationBuilder, HighlightBuilder highlightBuilder, Locale locale, String fieldName, int highlightFragmentSize, int highlightSnippetSize) {
        highlightBuilder.field(fieldName, highlightFragmentSize, highlightSnippetSize);
        String localizedFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        highlightBuilder.field(localizedFieldName, highlightFragmentSize, highlightSnippetSize);
        topHitsAggregationBuilder.highlighter(highlightBuilder);
    }

    protected void addHighlights(TopHitsAggregationBuilder topHitsAggregationBuilder, Locale locale, String[] highlightFieldNames, int highlightFragmentSize, int highlightSnippetSize, boolean highlightRequireFieldMatch) {
        HighlightBuilder highlightBuilder = new HighlightBuilder();
        for (String highlightFieldName : highlightFieldNames) {
            this.addHighlightedField(topHitsAggregationBuilder, highlightBuilder, locale, highlightFieldName, highlightFragmentSize, highlightSnippetSize);
        }
        highlightBuilder.postTags(new String[]{"</liferay-hl>"});
        highlightBuilder.preTags(new String[]{"<liferay-hl>"});
        highlightBuilder.requireFieldMatch(Boolean.valueOf(highlightRequireFieldMatch));
        topHitsAggregationBuilder.highlighter(highlightBuilder);
    }

    protected void addSelectedFields(TopHitsAggregationBuilder topHitsAggregationBuilder, String[] selectedFieldNames) {
        if (ArrayUtil.isEmpty((Object[])selectedFieldNames)) {
            topHitsAggregationBuilder.storedField("*");
        } else {
            topHitsAggregationBuilder.storedFields(Arrays.asList(selectedFieldNames));
        }
    }

    protected void addSorts(TopHitsAggregationBuilder topHitsAggregationBuilder, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>(sorts.length);
        for (Sort sort : sorts) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = Field.getSortFieldName((Sort)sort, (String)"_score"))) continue;
            sortFieldNames.add(sortFieldName);
            SortOrder sortOrder = SortOrder.ASC;
            if (sort.isReverse() || sortFieldName.equals("_score")) {
                sortOrder = SortOrder.DESC;
            }
            ScoreSortBuilder sortBuilder = null;
            if (sortFieldName.equals("_score")) {
                sortBuilder = SortBuilders.scoreSort();
            } else if (sort.getType() == 10) {
                GeoDistanceSort geoDistanceSort = (GeoDistanceSort)sort;
                ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
                for (GeoLocationPoint geoLocationPoint : geoDistanceSort.getGeoLocationPoints()) {
                    geoPoints.add(new GeoPoint(geoLocationPoint.getLatitude(), geoLocationPoint.getLongitude()));
                }
                GeoDistanceSortBuilder geoDistanceSortBuilder = SortBuilders.geoDistanceSort((String)sortFieldName, (GeoPoint[])geoPoints.toArray(new GeoPoint[geoPoints.size()]));
                geoDistanceSortBuilder.geoDistance(GeoDistance.ARC);
                List geoHashes = geoDistanceSort.getGeoHashes();
                if (!geoHashes.isEmpty()) {
                    geoDistanceSort.addGeoHash(geoHashes.toArray(new String[geoHashes.size()]));
                }
                sortBuilder = geoDistanceSortBuilder;
            } else {
                FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)sortFieldName);
                fieldSortBuilder.unmappedType("keyword");
                sortBuilder = fieldSortBuilder;
            }
            sortBuilder.order(sortOrder);
            topHitsAggregationBuilder.sort((SortBuilder)sortBuilder);
        }
    }

    protected TopHitsAggregationBuilder getTopHitsBuilder(GroupBy groupBy, Sort[] sorts, String[] selectedFieldNames, Locale locale, String[] highlightFieldNames, boolean highlightEnabled, boolean highlightRequireFieldMatch, int highlightFragmentSize, int highlightSnippetSize, int start, int size) {
        TopHitsAggregationBuilder topHitsAggregationBuilder = AggregationBuilders.topHits((String)"_topHits");
        int groupyByStart = groupBy.getStart();
        if (groupyByStart == 0) {
            groupyByStart = start;
        }
        topHitsAggregationBuilder.from(groupyByStart);
        int groupBySize = groupBy.getSize();
        if (groupBySize == 0) {
            groupBySize = size;
        }
        topHitsAggregationBuilder.size(groupBySize);
        if (highlightEnabled) {
            this.addHighlights(topHitsAggregationBuilder, locale, highlightFieldNames, highlightFragmentSize, highlightSnippetSize, highlightRequireFieldMatch);
        }
        this.addSelectedFields(topHitsAggregationBuilder, selectedFieldNames);
        this.addSorts(topHitsAggregationBuilder, sorts);
        return topHitsAggregationBuilder;
    }
}

