/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.facet;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.config.FacetConfiguration;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetProcessor;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetUtil;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, property={"class.name=com.liferay.portal.kernel.search.facet.DateRangeFacet"}, service={FacetProcessor.class})
public class DateRangeFacetProcessor
implements FacetProcessor<SearchRequestBuilder> {
    @Override
    public Optional<AggregationBuilder> processFacet(Facet facet) {
        FacetConfiguration facetConfiguration = facet.getFacetConfiguration();
        JSONObject jsonObject = facetConfiguration.getData();
        JSONArray jsonArray = jsonObject.getJSONArray("ranges");
        if (jsonArray == null) {
            return Optional.empty();
        }
        DateRangeAggregationBuilder dateRangeAggregationBuilder = AggregationBuilders.dateRange((String)FacetUtil.getAggregationName(facet));
        dateRangeAggregationBuilder.field(facetConfiguration.getFieldName());
        String format = jsonObject.getString("format");
        dateRangeAggregationBuilder.format(format);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject rangeJSONObject = jsonArray.getJSONObject(i);
            String range = rangeJSONObject.getString("range");
            range = range.replace("[", "");
            range = range.replace("]", "");
            String[] rangeParts = range.split(" ");
            dateRangeAggregationBuilder.addRange(rangeParts[0], rangeParts[2]);
        }
        return Optional.of(dateRangeAggregationBuilder);
    }
}

