/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseIndexWriter;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.suggest.SpellCheckIndexWriter;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.RefreshIndexRequest;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={IndexWriter.class})
public class ElasticsearchIndexWriter
extends BaseIndexWriter {
    @Reference(unbind="-")
    protected IndexNameBuilder indexNameBuilder;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected SearchEngineAdapter searchEngineAdapter;

    public void addDocument(SearchContext searchContext, Document document) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
        indexDocumentRequest.setType("LiferayDocumentType");
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            indexDocumentRequest.setRefresh(true);
        }
        this.searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
    }

    public void addDocuments(SearchContext searchContext, Collection<Document> documents) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        documents.forEach(document -> {
            IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
            indexDocumentRequest.setType("LiferayDocumentType");
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
        });
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    public void commit(SearchContext searchContext) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        RefreshIndexRequest refreshIndexRequest = new RefreshIndexRequest(new String[]{indexName});
        this.searchEngineAdapter.execute((IndexRequest)refreshIndexRequest);
    }

    public void deleteDocument(SearchContext searchContext, String uid) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(indexName, uid);
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            deleteDocumentRequest.setRefresh(true);
        }
        deleteDocumentRequest.setType("LiferayDocumentType");
        this.searchEngineAdapter.execute((DocumentRequest)deleteDocumentRequest);
    }

    public void deleteDocuments(SearchContext searchContext, Collection<String> uids) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        uids.forEach(uid -> {
            DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(indexName, uid);
            deleteDocumentRequest.setType("LiferayDocumentType");
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)deleteDocumentRequest);
        });
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    public void deleteEntityDocuments(SearchContext searchContext, String className) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        try {
            BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
            booleanQuery.add((Query)new MatchAllQuery(), BooleanClauseOccur.MUST);
            BooleanFilter booleanFilter = new BooleanFilter();
            booleanFilter.add((Filter)new TermFilter("entryClassName", className), BooleanClauseOccur.MUST);
            booleanQuery.setPreBooleanFilter(booleanFilter);
            DeleteByQueryDocumentRequest deleteByQueryDocumentRequest = new DeleteByQueryDocumentRequest((Query)booleanQuery, new String[]{indexName});
            if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
                deleteByQueryDocumentRequest.setRefresh(true);
            }
            this.searchEngineAdapter.execute((DocumentRequest)deleteByQueryDocumentRequest);
        }
        catch (ParseException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    public void partiallyUpdateDocument(SearchContext searchContext, Document document) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(indexName, document.getUID(), document);
        updateDocumentRequest.setType("LiferayDocumentType");
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            updateDocumentRequest.setRefresh(true);
        }
        this.searchEngineAdapter.execute((DocumentRequest)updateDocumentRequest);
    }

    public void partiallyUpdateDocuments(SearchContext searchContext, Collection<Document> documents) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        documents.forEach(document -> {
            UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(indexName, document.getUID(), document);
            updateDocumentRequest.setType("LiferayDocumentType");
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)updateDocumentRequest);
        });
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setSpellCheckIndexWriter(SpellCheckIndexWriter spellCheckIndexWriter) {
        super.setSpellCheckIndexWriter(spellCheckIndexWriter);
    }

    public void updateDocument(SearchContext searchContext, Document document) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(indexName, document.getUID());
        deleteDocumentRequest.setType("LiferayDocumentType");
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)deleteDocumentRequest);
        IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
        indexDocumentRequest.setType("LiferayDocumentType");
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    public void updateDocuments(SearchContext searchContext, Collection<Document> documents) {
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (PortalRunMode.isTestMode() || searchContext.isCommitImmediately()) {
            bulkDocumentRequest.setRefresh(true);
        }
        documents.forEach(document -> {
            DeleteDocumentRequest deleteDocumentRequest = new DeleteDocumentRequest(indexName, document.getUID());
            deleteDocumentRequest.setType("LiferayDocumentType");
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)deleteDocumentRequest);
            IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(indexName, document);
            indexDocumentRequest.setType("LiferayDocumentType");
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)indexDocumentRequest);
        });
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }
}

