/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexSearcher;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.suggest.QuerySuggester;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Props;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration;
import com.liferay.portal.search.elasticsearch6.internal.index.IndexNameBuilder;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.search.elasticsearch6.configuration.ElasticsearchConfiguration"}, immediate=true, property={"search.engine.impl=Elasticsearch"}, service={IndexSearcher.class})
public class ElasticsearchIndexSearcher
extends BaseIndexSearcher {
    @Reference
    protected IndexNameBuilder indexNameBuilder;
    @Reference
    protected Props props;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected SearchEngineAdapter searchEngineAdapter;
    private static final Log _log = LogFactoryUtil.getLog(ElasticsearchIndexSearcher.class);
    private volatile ElasticsearchConfiguration _elasticsearchConfiguration;
    private boolean _logExceptionsOnly;

    public String getQueryString(SearchContext searchContext, Query query) {
        return this.searchEngineAdapter.getQueryString(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        Hits hits;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            int start = searchContext.getStart();
            int end = searchContext.getEnd();
            if (start == -1) {
                start = 0;
            } else if (start < 0) {
                throw new IllegalArgumentException("Invalid start " + start);
            }
            if (end == -1) {
                end = GetterUtil.getInteger((String)this.props.get("index.search.limit"));
            } else if (end < 0) {
                throw new IllegalArgumentException("Invalid end " + end);
            }
            Hits hits2 = null;
            while (true) {
                SearchSearchRequest searchSearchRequest = this.createSearchSearchRequest(searchContext, query, start, end);
                SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this.searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
                searchContext.setAttribute("queryString", (Serializable)((Object)searchSearchResponse.getSearchRequestString()));
                hits2 = searchSearchResponse.getHits();
                Document[] documents = hits2.getDocs();
                if (documents.length != 0 || start == 0) break;
                int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)start, (int)end, (int)hits2.getLength());
                start = startAndEnd[0];
                end = startAndEnd[1];
            }
            hits2.setStart(stopWatch.getStartTime());
            hits = hits2;
        }
        catch (Exception e) {
            HitsImpl hitsImpl;
            try {
                if (!this.handle(e)) {
                    if (this._logExceptionsOnly) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)e, (Throwable)e);
                        }
                    } else {
                        throw new SearchException(e.getMessage(), (Throwable)e);
                    }
                }
                hitsImpl = new HitsImpl();
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
            }
            return hitsImpl;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
        }
        return hits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long searchCount(SearchContext searchContext, Query query) throws SearchException {
        long l;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            CountSearchRequest countSearchRequest = new CountSearchRequest();
            QueryConfig queryConfig = searchContext.getQueryConfig();
            String[] indexNames = this.getSelectedIndexNames(queryConfig, searchContext);
            countSearchRequest.setIndexNames(indexNames);
            countSearchRequest.setPostFilter(query.getPostFilter());
            countSearchRequest.setQuery(query);
            CountSearchResponse countSearchResponse = (CountSearchResponse)this.searchEngineAdapter.execute((SearchRequest)countSearchRequest);
            searchContext.setAttribute("queryString", (Serializable)((Object)countSearchResponse.getSearchRequestString()));
            l = countSearchResponse.getCount();
        }
        catch (Exception e) {
            long l2;
            try {
                if (!this.handle(e)) {
                    if (this._logExceptionsOnly) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)e, (Throwable)e);
                        }
                    } else {
                        throw new SearchException(e.getMessage(), (Throwable)e);
                    }
                }
                l2 = 0L;
            }
            catch (Throwable throwable) {
                if (_log.isInfoEnabled()) {
                    stopWatch.stop();
                    _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
                }
                throw throwable;
            }
            if (_log.isInfoEnabled()) {
                stopWatch.stop();
                _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
            }
            return l2;
        }
        if (_log.isInfoEnabled()) {
            stopWatch.stop();
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Searching ", query.toString(), " took ", stopWatch.getTime(), " ms"}));
        }
        return l;
    }

    @Reference(target="(search.engine.impl=Elasticsearch)", unbind="-")
    public void setQuerySuggester(QuerySuggester querySuggester) {
        super.setQuerySuggester(querySuggester);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._elasticsearchConfiguration = (ElasticsearchConfiguration)ConfigurableUtil.createConfigurable(ElasticsearchConfiguration.class, properties);
        this._logExceptionsOnly = this._elasticsearchConfiguration.logExceptionsOnly();
    }

    protected SearchSearchRequest createSearchSearchRequest(SearchContext searchContext, Query query, int start, int end) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        searchSearchRequest.setAlternateUidFieldName(queryConfig.getAlternateUidFieldName());
        boolean basicFacetSelection = GetterUtil.getBoolean((Object)searchContext.getAttribute("search.basic.facet.selection"));
        searchSearchRequest.setBasicFacetSelection(basicFacetSelection);
        String[] indexNames = this.getSelectedIndexNames(queryConfig, searchContext);
        searchSearchRequest.setIndexNames(indexNames);
        searchSearchRequest.putAllFacets(searchContext.getFacets());
        searchSearchRequest.setGroupBy(searchContext.getGroupBy());
        searchSearchRequest.setHighlightEnabled(queryConfig.isHighlightEnabled());
        searchSearchRequest.setHighlightFieldNames(queryConfig.getHighlightFieldNames());
        searchSearchRequest.setHighlightFragmentSize(queryConfig.getHighlightFragmentSize());
        searchSearchRequest.setHighlightSnippetSize(queryConfig.getHighlightSnippetSize());
        searchSearchRequest.setLocale(queryConfig.getLocale());
        searchSearchRequest.setHighlightRequireFieldMatch(queryConfig.isHighlightRequireFieldMatch());
        boolean luceneSyntax = GetterUtil.getBoolean((Object)searchContext.getAttribute("search.lucene.syntax"));
        searchSearchRequest.setLuceneSyntax(luceneSyntax);
        searchSearchRequest.setQuery(query);
        searchSearchRequest.setPostFilter(query.getPostFilter());
        String preference = (String)((Object)searchContext.getAttribute("elasticsearch.search.request.preference"));
        if (!Validator.isBlank((String)preference)) {
            searchSearchRequest.setPreference(preference);
        }
        searchSearchRequest.setScoreEnabled(queryConfig.isScoreEnabled());
        searchSearchRequest.setSelectedFieldNames(queryConfig.getSelectedFieldNames());
        int size = end - start;
        searchSearchRequest.setSize(size);
        searchSearchRequest.setStart(start);
        searchSearchRequest.setSorts(searchContext.getSorts());
        searchSearchRequest.setStats(searchContext.getStats());
        return searchSearchRequest;
    }

    protected String[] getSelectedIndexNames(QueryConfig queryConfig, SearchContext searchContext) {
        Object[] selectedIndexNames = queryConfig.getSelectedIndexNames();
        if (ArrayUtil.isNotEmpty((Object[])selectedIndexNames)) {
            return selectedIndexNames;
        }
        String indexName = this.indexNameBuilder.getIndexName(searchContext.getCompanyId());
        return new String[]{indexName};
    }

    protected boolean handle(Exception e) {
        Throwable throwable = e.getCause();
        if (throwable == null) {
            return false;
        }
        String message = throwable.getMessage();
        if (message == null) {
            return false;
        }
        if (message.contains("Fielddata is disabled on text fields by default.")) {
            _log.error((Object)"Unable to aggregate facet on a nonkeyword field", (Throwable)e);
            return true;
        }
        return false;
    }
}

