/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal;

import com.liferay.portal.kernel.search.AbstractSearchEngineConfigurator;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineConfigurator;
import com.liferay.portal.kernel.search.SearchEngineHelper;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnection;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={SearchEngineConfigurator.class})
public class ElasticsearchEngineConfigurator
extends AbstractSearchEngineConfigurator {
    @Reference
    protected SearchEngineHelper searchEngineHelper;
    @Reference
    private ElasticsearchConnectionManager _elasticsearchConnectionManager;
    @Reference(target="(!(search.engine.impl=*))")
    private IndexSearcher _indexSearcher;
    @Reference(target="(!(search.engine.impl=*))")
    private IndexWriter _indexWriter;
    private final Map<String, SearchEngine> _searchEngines = new ConcurrentHashMap<String, SearchEngine>();

    public void destroy() {
        ElasticsearchConnection elasticsearchConnection = this._elasticsearchConnectionManager.getElasticsearchConnection();
        elasticsearchConnection.close();
        super.destroy();
    }

    @Activate
    protected void activate() {
        this.setSearchEngines(this._searchEngines);
    }

    protected String getDefaultSearchEngineId() {
        return "SYSTEM_ENGINE";
    }

    protected IndexSearcher getIndexSearcher() {
        return this._indexSearcher;
    }

    protected IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    protected ClassLoader getOperatingClassloader() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return clazz.getClassLoader();
    }

    protected SearchEngineHelper getSearchEngineHelper() {
        return this.searchEngineHelper;
    }

    protected void initialize() {
        Thread thread = new Thread(() -> this._elasticsearchConnectionManager.connect(), "Elasticsearch initialization thread");
        thread.setDaemon(true);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("Unable to initialize Elasticsearch engine", ie);
        }
        super.initialize();
    }

    @Reference(target="(&(search.engine.id=SYSTEM_ENGINE)(search.engine.impl=Elasticsearch))")
    protected void setSearchEngine(SearchEngine searchEngine, Map<String, Object> properties) {
        String searchEngineId = MapUtil.getString(properties, (String)"search.engine.id");
        this._searchEngines.put(searchEngineId, searchEngine);
    }

    protected void unsetSearchEngine(SearchEngine searchEngine, Map<String, Object> properties) {
        String searchEngineId = MapUtil.getString(properties, (String)"search.engine.id");
        if (Validator.isNull((String)searchEngineId)) {
            return;
        }
        this._searchEngines.remove(searchEngineId);
    }
}

