/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentResponse;

import org.elasticsearch.client.Client;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Dylan Rebelak
 */
@Component(
	immediate = true, service = DeleteByQueryDocumentRequestExecutor.class
)
public class DeleteByQueryDocumentRequestExecutorImpl
	implements DeleteByQueryDocumentRequestExecutor {

	@Override
	public DeleteByQueryDocumentResponse execute(
		DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {

		DeleteByQueryRequestBuilder deleteByQueryRequestBuilder =
			createDeleteByQueryRequestBuilder(deleteByQueryDocumentRequest);

		BulkByScrollResponse bulkByScrollResponse =
			deleteByQueryRequestBuilder.get();

		TimeValue timeValue = bulkByScrollResponse.getTook();

		DeleteByQueryDocumentResponse deleteByQueryDocumentResponse =
			new DeleteByQueryDocumentResponse(
				bulkByScrollResponse.getDeleted(), timeValue.getMillis());

		return deleteByQueryDocumentResponse;
	}

	protected DeleteByQueryRequestBuilder createDeleteByQueryRequestBuilder(
		DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {

		Client client = elasticsearchConnectionManager.getClient();

		DeleteByQueryRequestBuilder deleteByQueryRequestBuilder =
			DeleteByQueryAction.INSTANCE.newRequestBuilder(client);

		Query query = deleteByQueryDocumentRequest.getQuery();

		QueryBuilder queryBuilder = queryTranslator.translate(query, null);

		deleteByQueryRequestBuilder.filter(queryBuilder);

		deleteByQueryRequestBuilder.refresh(
			deleteByQueryDocumentRequest.isRefresh());
		deleteByQueryRequestBuilder.source(
			deleteByQueryDocumentRequest.getIndexNames());

		return deleteByQueryRequestBuilder;
	}

	@Reference
	protected ElasticsearchConnectionManager elasticsearchConnectionManager;

	@Reference(target = "(search.engine.impl=Elasticsearch)")
	protected QueryTranslator<QueryBuilder> queryTranslator;

}