/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.sort;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GeoDistanceSort;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.geolocation.GeoLocationPoint;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch6.internal.sort.SortTranslator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.osgi.service.component.annotations.Component;

@Component(service={SortTranslator.class})
public class DefaultSortTranslator
implements SortTranslator {
    @Override
    public void translate(SearchRequestBuilder searchRequestBuilder, Sort[] sorts) {
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            return;
        }
        HashSet<String> sortFieldNames = new HashSet<String>(sorts.length);
        for (Sort sort : sorts) {
            String sortFieldName;
            if (sort == null || sortFieldNames.contains(sortFieldName = this.getSortFieldName(sort, "_score"))) continue;
            sortFieldNames.add(sortFieldName);
            SortOrder sortOrder = SortOrder.ASC;
            if (sort.isReverse() || sortFieldName.equals("_score")) {
                sortOrder = SortOrder.DESC;
            }
            ScoreSortBuilder sortBuilder = null;
            if (sortFieldName.equals("_score")) {
                sortBuilder = SortBuilders.scoreSort();
            } else if (sort.getType() == 10) {
                GeoDistanceSort geoDistanceSort = (GeoDistanceSort)sort;
                ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
                for (GeoLocationPoint geoLocationPoint : geoDistanceSort.getGeoLocationPoints()) {
                    geoPoints.add(new GeoPoint(geoLocationPoint.getLatitude(), geoLocationPoint.getLongitude()));
                }
                GeoDistanceSortBuilder geoDistanceSortBuilder = SortBuilders.geoDistanceSort((String)sortFieldName, (GeoPoint[])geoPoints.toArray(new GeoPoint[geoPoints.size()]));
                geoDistanceSortBuilder.geoDistance(GeoDistance.ARC);
                List geoHashes = geoDistanceSort.getGeoHashes();
                if (!geoHashes.isEmpty()) {
                    geoDistanceSort.addGeoHash(geoHashes.toArray(new String[geoHashes.size()]));
                }
                sortBuilder = geoDistanceSortBuilder;
            } else {
                FieldSortBuilder fieldSortBuilder = SortBuilders.fieldSort((String)sortFieldName);
                fieldSortBuilder.unmappedType("keyword");
                sortBuilder = fieldSortBuilder;
            }
            sortBuilder.order(sortOrder);
            searchRequestBuilder.addSort((SortBuilder)sortBuilder);
        }
    }

    protected String getSortFieldName(Sort sort, String scoreFieldName) {
        String sortFieldName = sort.getFieldName();
        if (Objects.equals(sortFieldName, "priority")) {
            return sortFieldName;
        }
        return Field.getSortFieldName((Sort)sort, (String)scoreFieldName);
    }
}

