/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.MultisearchSearchRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchResponseAssembler;
import com.liferay.portal.search.engine.adapter.search.MultisearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.MultisearchSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.action.search.MultiSearchAction;
import org.elasticsearch.action.search.MultiSearchRequestBuilder;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={MultisearchSearchRequestExecutor.class})
public class MultisearchSearchRequestExecutorImpl
implements MultisearchSearchRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected SearchSearchRequestAssembler searchSearchRequestAssembler;
    @Reference
    protected SearchSearchResponseAssembler searchSearchResponseAssembler;

    @Override
    public MultisearchSearchResponse execute(MultisearchSearchRequest multisearchSearchRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        MultiSearchRequestBuilder multiSearchRequestBuilder = MultiSearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        List searchSearchRequests = multisearchSearchRequest.getSearchSearchRequests();
        ArrayList searchRequestHolders = new ArrayList(searchSearchRequests.size());
        searchSearchRequests.forEach(searchSearchRequest -> {
            SearchRequestBuilder searchRequestBuilder = SearchAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
            this.searchSearchRequestAssembler.assemble(searchRequestBuilder, (SearchSearchRequest)searchSearchRequest);
            SearchRequestHolder searchRequestHolder = new SearchRequestHolder((SearchSearchRequest)searchSearchRequest, searchRequestBuilder.toString());
            searchRequestHolders.add(searchRequestHolder);
            multiSearchRequestBuilder.add(searchRequestBuilder);
        });
        MultiSearchResponse multiSearchResponse = (MultiSearchResponse)multiSearchRequestBuilder.get();
        Iterator multiSearchResponseItems = multiSearchResponse.iterator();
        MultisearchSearchResponse multisearchSearchResponse = new MultisearchSearchResponse();
        int counter = 0;
        while (multiSearchResponseItems.hasNext()) {
            MultiSearchResponse.Item multiSearchResponseItem = (MultiSearchResponse.Item)multiSearchResponseItems.next();
            SearchResponse searchResponse = multiSearchResponseItem.getResponse();
            SearchSearchResponse searchSearchResponse = new SearchSearchResponse();
            SearchRequestHolder searchRequestHolder = (SearchRequestHolder)searchRequestHolders.get(counter);
            this.searchSearchResponseAssembler.assemble(searchResponse, searchSearchResponse, searchRequestHolder.getSearchSearchRequest(), searchRequestHolder.getSearchRequestBuilderString());
            ++counter;
        }
        return multisearchSearchResponse;
    }

    private class SearchRequestHolder {
        private final String _searchRequestBuilderString;
        private final SearchSearchRequest _searchSearchRequest;

        public SearchRequestHolder(SearchSearchRequest searchSearchRequest, String searchRequestBuilderString) {
            this._searchSearchRequest = searchSearchRequest;
            this._searchRequestBuilderString = searchRequestBuilderString;
        }

        public String getSearchRequestBuilderString() {
            return this._searchRequestBuilderString;
        }

        public SearchSearchRequest getSearchSearchRequest() {
            return this._searchSearchRequest;
        }
    }
}

