/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndicesExistsIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsAction;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IndicesExistsIndexRequestExecutor.class})
public class IndicesExistsIndexRequestExecutorImpl
implements IndicesExistsIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public IndicesExistsIndexResponse execute(IndicesExistsIndexRequest indicesExistsIndexRequest) {
        IndicesExistsRequestBuilder indicesExistsRequestBuilder = this.createIndicesExistsRequestBuilder(indicesExistsIndexRequest);
        IndicesExistsResponse indicesExistsResponse = (IndicesExistsResponse)indicesExistsRequestBuilder.get();
        IndicesExistsIndexResponse indicesExistsIndexResponse = new IndicesExistsIndexResponse(indicesExistsResponse.isExists());
        return indicesExistsIndexResponse;
    }

    protected IndicesExistsRequestBuilder createIndicesExistsRequestBuilder(IndicesExistsIndexRequest indicesExistsIndexRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        IndicesExistsRequestBuilder indicesExistsRequestBuilder = IndicesExistsAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        indicesExistsRequestBuilder.setIndices(indicesExistsIndexRequest.getIndexNames());
        return indicesExistsRequestBuilder;
    }
}

