/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.FlushIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndexRequestShardFailureTranslator;
import com.liferay.portal.search.engine.adapter.index.FlushIndexRequest;
import com.liferay.portal.search.engine.adapter.index.FlushIndexResponse;
import com.liferay.portal.search.engine.adapter.index.IndexRequestShardFailure;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.flush.FlushAction;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.rest.RestStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={FlushIndexRequestExecutor.class})
public class FlushIndexRequestExecutorImpl
implements FlushIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected IndexRequestShardFailureTranslator indexRequestShardFailureTranslator;

    @Override
    public FlushIndexResponse execute(FlushIndexRequest flushIndexRequest) {
        FlushRequestBuilder flushRequestBuilder = this.createFlushRequestBuilder(flushIndexRequest);
        FlushResponse flushResponse = (FlushResponse)flushRequestBuilder.get();
        FlushIndexResponse flushIndexResponse = new FlushIndexResponse();
        flushIndexResponse.setFailedShards(flushResponse.getFailedShards());
        flushIndexResponse.setSuccessfulShards(flushResponse.getSuccessfulShards());
        flushIndexResponse.setTotalShards(flushResponse.getTotalShards());
        RestStatus restStatus = flushResponse.getStatus();
        flushIndexResponse.setRestStatus(restStatus.getStatus());
        Object[] shardOperationFailedExceptions = flushResponse.getShardFailures();
        if (ArrayUtil.isNotEmpty((Object[])shardOperationFailedExceptions)) {
            for (Object shardOperationFailedException : shardOperationFailedExceptions) {
                IndexRequestShardFailure indexRequestShardFailure = this.indexRequestShardFailureTranslator.translate((ShardOperationFailedException)shardOperationFailedException);
                flushIndexResponse.addIndexRequestShardFailure(indexRequestShardFailure);
            }
        }
        return flushIndexResponse;
    }

    protected FlushRequestBuilder createFlushRequestBuilder(FlushIndexRequest flushIndexRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        FlushRequestBuilder flushRequestBuilder = FlushAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        flushRequestBuilder.setIndices(flushIndexRequest.getIndexNames());
        flushRequestBuilder.setForce(flushIndexRequest.isForce());
        flushRequestBuilder.setWaitIfOngoing(flushIndexRequest.isWaitIfOngoing());
        return flushRequestBuilder;
    }
}

