/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.DeleteIndexRequestExecutor;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.IndicesOptionsTranslator;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DeleteIndexRequestExecutor.class})
public class DeleteIndexRequestExecutorImpl
implements DeleteIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;
    @Reference
    protected IndicesOptionsTranslator indicesOptionsTranslator;

    @Override
    public com.liferay.portal.search.engine.adapter.index.DeleteIndexResponse execute(DeleteIndexRequest deleteIndexRequest) {
        DeleteIndexRequestBuilder deleteIndexRequestBuilder = this.createDeleteIndexRequestBuilder(deleteIndexRequest);
        DeleteIndexResponse elasticsearchDeleteIndexResponse = (DeleteIndexResponse)deleteIndexRequestBuilder.get();
        com.liferay.portal.search.engine.adapter.index.DeleteIndexResponse deleteIndexResponse = new com.liferay.portal.search.engine.adapter.index.DeleteIndexResponse(elasticsearchDeleteIndexResponse.isAcknowledged());
        return deleteIndexResponse;
    }

    protected IndicesOptions convert(com.liferay.portal.search.engine.adapter.index.IndicesOptions indicesOptions) {
        if (indicesOptions == null) {
            return IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true);
        }
        return IndicesOptions.fromOptions((boolean)indicesOptions.isIgnoreUnavailable(), (boolean)indicesOptions.isAllowNoIndices(), (boolean)indicesOptions.isExpandToOpenIndices(), (boolean)indicesOptions.isExpandToClosedIndices());
    }

    protected DeleteIndexRequestBuilder createDeleteIndexRequestBuilder(DeleteIndexRequest deleteIndexRequest) {
        AdminClient adminClient = this.elasticsearchConnectionManager.getAdminClient();
        IndicesAdminClient indicesAdminClient = adminClient.indices();
        DeleteIndexRequestBuilder deleteIndexRequestBuilder = indicesAdminClient.prepareDelete(deleteIndexRequest.getIndexNames());
        IndicesOptions indicesOptions = this.indicesOptionsTranslator.translate(deleteIndexRequest.getIndicesOptions());
        deleteIndexRequestBuilder.setIndicesOptions(indicesOptions);
        return deleteIndexRequestBuilder;
    }
}

