/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.document.DefaultElasticsearchDocumentFactory;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequestTranslator;
import com.liferay.portal.search.engine.adapter.document.DeleteDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import java.io.IOException;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteAction;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexAction;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateAction;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.engine.impl=Elasticsearch"}, service={BulkableDocumentRequestTranslator.class})
public class ElasticsearchBulkableDocumentRequestTranslator
implements BulkableDocumentRequestTranslator<DeleteRequestBuilder, IndexRequestBuilder, UpdateRequestBuilder, BulkRequestBuilder> {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    public DeleteRequestBuilder translate(DeleteDocumentRequest deleteDocumentRequest, BulkRequestBuilder searchEngineAdapterRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        DeleteRequestBuilder deleteRequestBuilder = DeleteAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        deleteRequestBuilder.setId(deleteDocumentRequest.getUid());
        deleteRequestBuilder.setIndex(deleteDocumentRequest.getIndexName());
        if (deleteDocumentRequest.isRefresh()) {
            deleteRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        }
        deleteRequestBuilder.setType(deleteDocumentRequest.getType());
        if (searchEngineAdapterRequest != null) {
            searchEngineAdapterRequest.add(deleteRequestBuilder);
        }
        return deleteRequestBuilder;
    }

    public IndexRequestBuilder translate(IndexDocumentRequest indexDocumentRequest, BulkRequestBuilder searchEngineAdapterRequest) {
        try {
            Client client = this.elasticsearchConnectionManager.getClient();
            IndexRequestBuilder indexRequestBuilder = IndexAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
            Document document = indexDocumentRequest.getDocument();
            indexRequestBuilder.setId(document.getUID());
            indexRequestBuilder.setIndex(indexDocumentRequest.getIndexName());
            if (indexDocumentRequest.isRefresh()) {
                indexRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            indexRequestBuilder.setType(indexDocumentRequest.getType());
            DefaultElasticsearchDocumentFactory elasticsearchDocumentFactory = new DefaultElasticsearchDocumentFactory();
            String elasticsearchDocument = elasticsearchDocumentFactory.getElasticsearchDocument(document);
            indexRequestBuilder.setSource(elasticsearchDocument, XContentType.JSON);
            if (searchEngineAdapterRequest != null) {
                searchEngineAdapterRequest.add(indexRequestBuilder);
            }
            return indexRequestBuilder;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    public UpdateRequestBuilder translate(UpdateDocumentRequest updateDocumentRequest, BulkRequestBuilder searchEngineAdapterRequest) {
        try {
            Client client = this.elasticsearchConnectionManager.getClient();
            UpdateRequestBuilder updateRequestBuilder = UpdateAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
            Document document = updateDocumentRequest.getDocument();
            updateRequestBuilder.setId(document.getUID());
            updateRequestBuilder.setIndex(updateDocumentRequest.getIndexName());
            if (updateDocumentRequest.isRefresh()) {
                updateRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            updateRequestBuilder.setType(updateDocumentRequest.getType());
            DefaultElasticsearchDocumentFactory elasticsearchDocumentFactory = new DefaultElasticsearchDocumentFactory();
            String elasticsearchDocument = elasticsearchDocumentFactory.getElasticsearchDocument(document);
            updateRequestBuilder.setDoc(elasticsearchDocument, XContentType.JSON);
            if (searchEngineAdapterRequest != null) {
                searchEngineAdapterRequest.add(updateRequestBuilder);
            }
            return updateRequestBuilder;
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }
}

