/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.cluster.StateClusterRequestExecutor;
import com.liferay.portal.search.engine.adapter.cluster.StateClusterRequest;
import com.liferay.portal.search.engine.adapter.cluster.StateClusterResponse;
import java.io.IOException;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.xpack.watcher.watch.Payload;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StateClusterRequestExecutor.class})
public class StateClusterRequestExecutorImpl
implements StateClusterRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public StateClusterResponse execute(StateClusterRequest stateClusterRequest) {
        ClusterStateRequestBuilder clusterStateRequestBuilder = this.createClusterStateRequestBuilder(stateClusterRequest);
        ClusterStateResponse clusterStateResponse = (ClusterStateResponse)clusterStateRequestBuilder.get();
        try {
            ClusterState clusterState = clusterStateResponse.getState();
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            xContentBuilder.startObject();
            xContentBuilder = clusterState.toXContent(xContentBuilder, Payload.XContent.EMPTY_PARAMS);
            xContentBuilder.endObject();
            return new StateClusterResponse(xContentBuilder.string());
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
    }

    protected ClusterStateRequestBuilder createClusterStateRequestBuilder(StateClusterRequest stateClusterRequest) {
        ClusterAdminClient clusterAdminClient = this.elasticsearchConnectionManager.getClusterAdminClient();
        ClusterStateRequestBuilder clusterStateRequestBuilder = clusterAdminClient.prepareState();
        clusterStateRequestBuilder.setIndices(stateClusterRequest.getIndexNames());
        return clusterStateRequestBuilder;
    }
}

