/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.query;

import com.liferay.portal.kernel.search.generic.FuzzyQuery;
import com.liferay.portal.search.elasticsearch6.internal.query.FuzzyQueryTranslator;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={FuzzyQueryTranslator.class})
public class FuzzyQueryTranslatorImpl
implements FuzzyQueryTranslator {
    @Override
    public QueryBuilder translate(FuzzyQuery fuzzyQuery) {
        FuzzyQueryBuilder fuzzyQueryBuilder = QueryBuilders.fuzzyQuery((String)fuzzyQuery.getField(), (String)fuzzyQuery.getValue());
        if (fuzzyQuery.getFuzziness() != null) {
            fuzzyQueryBuilder.fuzziness(Fuzziness.build((Object)fuzzyQuery.getFuzziness()));
        }
        if (fuzzyQuery.getMaxExpansions() != null) {
            fuzzyQueryBuilder.maxExpansions(fuzzyQuery.getMaxExpansions().intValue());
        }
        if (fuzzyQuery.getPrefixLength() != null) {
            fuzzyQueryBuilder.prefixLength(fuzzyQuery.getPrefixLength().intValue());
        }
        if (!fuzzyQuery.isDefaultBoost()) {
            fuzzyQueryBuilder.boost(fuzzyQuery.getBoost());
        }
        return fuzzyQueryBuilder;
    }
}

