/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.filter;

import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterVisitor;
import com.liferay.portal.search.elasticsearch6.internal.filter.BooleanFilterTranslator;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={BooleanFilterTranslator.class})
public class BooleanFilterTranslatorImpl
implements BooleanFilterTranslator {
    @Override
    public QueryBuilder translate(BooleanFilter booleanFilter, FilterVisitor<QueryBuilder> filterVisitor) {
        QueryBuilder queryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        for (BooleanClause booleanClause : booleanFilter.getMustBooleanClauses()) {
            queryBuilder = this.translate((BooleanClause<Filter>)booleanClause, filterVisitor);
            boolQueryBuilder.must(queryBuilder);
        }
        for (BooleanClause booleanClause : booleanFilter.getMustNotBooleanClauses()) {
            queryBuilder = this.translate((BooleanClause<Filter>)booleanClause, filterVisitor);
            boolQueryBuilder.mustNot(queryBuilder);
        }
        for (BooleanClause booleanClause : booleanFilter.getShouldBooleanClauses()) {
            queryBuilder = this.translate((BooleanClause<Filter>)booleanClause, filterVisitor);
            boolQueryBuilder.should(queryBuilder);
        }
        return boolQueryBuilder;
    }

    protected QueryBuilder translate(BooleanClause<Filter> booleanClause, FilterVisitor<QueryBuilder> filterVisitor) {
        Filter filter = (Filter)booleanClause.getClause();
        return (QueryBuilder)filter.accept(filterVisitor);
    }
}

