/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.suggest;

import com.liferay.portal.kernel.search.suggest.TermSuggester;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.suggest.BaseSuggesterTranslatorImpl;
import com.liferay.portal.search.elasticsearch6.internal.suggest.TermSuggesterTranslator;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.elasticsearch.search.suggest.SuggestBuilders;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.term.TermSuggestionBuilder;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={TermSuggesterTranslator.class})
public class TermSuggesterTranslatorImpl
extends BaseSuggesterTranslatorImpl
implements TermSuggesterTranslator {
    @Override
    public SuggestBuilder translate(TermSuggester termSuggester) {
        SuggestBuilder suggestBuilder = new SuggestBuilder();
        TermSuggestionBuilder termSuggesterBuilder = SuggestBuilders.termSuggestion((String)termSuggester.getField());
        if (Validator.isNotNull((String)termSuggester.getAnalyzer())) {
            termSuggesterBuilder.analyzer(termSuggester.getAnalyzer());
        }
        if (termSuggester.getAccuracy() != null) {
            termSuggesterBuilder.accuracy(termSuggester.getAccuracy().floatValue());
        }
        if (termSuggester.getMaxEdits() != null) {
            termSuggesterBuilder.maxEdits(termSuggester.getMaxEdits().intValue());
        }
        if (termSuggester.getMaxInspections() != null) {
            termSuggesterBuilder.maxInspections(termSuggester.getMaxInspections().intValue());
        }
        if (termSuggester.getMaxTermFreq() != null) {
            termSuggesterBuilder.maxTermFreq((float)termSuggester.getMaxTermFreq().intValue());
        }
        if (termSuggester.getMinWordLength() != null) {
            termSuggesterBuilder.minWordLength(termSuggester.getMinWordLength().intValue());
        }
        if (termSuggester.getMinDocFreq() != null) {
            termSuggesterBuilder.minDocFreq((float)termSuggester.getMinDocFreq().intValue());
        }
        if (termSuggester.getPrefixLength() != null) {
            termSuggesterBuilder.prefixLength(termSuggester.getPrefixLength().intValue());
        }
        if (termSuggester.getShardSize() != null) {
            termSuggesterBuilder.shardSize(termSuggester.getShardSize());
        }
        if (termSuggester.getSize() != null) {
            termSuggesterBuilder.size(termSuggester.getSize().intValue());
        }
        if (termSuggester.getSort() != null) {
            termSuggesterBuilder.sort(this.translateSort(termSuggester.getSort()));
        }
        if (termSuggester.getStringDistance() != null) {
            termSuggesterBuilder.stringDistance(this.translateDistance(termSuggester.getStringDistance()));
        }
        if (termSuggester.getSuggestMode() != null) {
            termSuggesterBuilder.suggestMode(this.translateMode(termSuggester.getSuggestMode()));
        }
        termSuggesterBuilder.text(termSuggester.getValue());
        suggestBuilder.addSuggestion(termSuggester.getName(), (SuggestionBuilder)termSuggesterBuilder);
        return suggestBuilder;
    }
}

