/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.settings;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.XContentType;

public class SettingsBuilder {
    private final Settings.Builder _builder;

    public SettingsBuilder(Settings.Builder builder) {
        this._builder = builder;
    }

    public Settings build() {
        return this._builder.build();
    }

    public Settings.Builder getBuilder() {
        return this._builder;
    }

    public void loadFromSource(String source) {
        if (StringUtils.isBlank((String)source)) {
            return;
        }
        try {
            this._builder.loadFromSource(source, XContentType.JSON);
        }
        catch (SettingsException se) {
            this._builder.loadFromSource(source, XContentType.YAML);
        }
    }

    public void put(String key, boolean value) {
        this._builder.put(key, value);
    }

    public void put(String key, String value) {
        if (!StringUtils.isBlank((String)value)) {
            this._builder.put(key, value);
        }
    }
}

