/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.response;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.HitsImpl;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.search.StatsResults;
import com.liferay.portal.kernel.search.facet.Facet;
import com.liferay.portal.kernel.search.facet.collector.FacetCollector;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.SearchHitDocumentTranslator;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetCollectorFactory;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetUtil;
import com.liferay.portal.search.elasticsearch6.internal.search.response.SearchResponseTranslator;
import com.liferay.portal.search.elasticsearch6.internal.stats.StatsTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchResponseTranslator.class})
public class DefaultSearchResponseTranslator
implements SearchResponseTranslator {
    @Reference
    protected SearchHitDocumentTranslator searchHitDocumentTranslator;
    @Reference
    protected StatsTranslator statsTranslator;

    @Override
    public Hits translate(SearchResponse searchResponse, Map<String, Facet> facetMap, GroupBy groupBy, Map<String, Stats> statsMap, String alternateUidFieldName, String[] highlightFieldNames, Locale locale) {
        SearchHits searchHits = searchResponse.getHits();
        HitsImpl hits = new HitsImpl();
        this.updateFacetCollectors(searchResponse, facetMap);
        this.updateGroupedHits(searchResponse, groupBy, (Hits)hits, alternateUidFieldName, highlightFieldNames, locale);
        this.updateStatsResults(searchResponse, (Hits)hits, statsMap);
        TimeValue timeValue = searchResponse.getTook();
        hits.setSearchTime((float)timeValue.getSecondsFrac());
        return this.processSearchHits(searchHits, (Hits)hits, alternateUidFieldName, highlightFieldNames, locale);
    }

    protected void addSnippets(Document document, Map<String, HighlightField> highlightFields, String fieldName, Locale locale) {
        String snippetFieldName = Field.getLocalizedName((Locale)locale, (String)fieldName);
        HighlightField highlightField = highlightFields.get(snippetFieldName);
        if (highlightField == null) {
            highlightField = highlightFields.get(fieldName);
            snippetFieldName = fieldName;
        }
        if (highlightField == null) {
            return;
        }
        Object[] array = highlightField.fragments();
        document.addText("snippet".concat("_").concat(snippetFieldName), StringUtil.merge((Object[])array, (String)"..."));
    }

    protected void addSnippets(SearchHit hit, Document document, String[] highlightFieldNames, Locale locale) {
        Map highlightFields = hit.getHighlightFields();
        if (MapUtil.isEmpty((Map)highlightFields)) {
            return;
        }
        for (String highlightFieldName : highlightFieldNames) {
            this.addSnippets(document, highlightFields, highlightFieldName, locale);
        }
    }

    protected FacetCollector getFacetCollector(Facet facet, Map<String, Aggregation> aggregationsMap) {
        FacetCollectorFactory facetCollectorFactory = new FacetCollectorFactory();
        return facetCollectorFactory.getFacetCollector(aggregationsMap.get(FacetUtil.getAggregationName(facet)));
    }

    protected void populateUID(Document document, String alternateUidFieldName) {
        Field uidField = document.getField("uid");
        if (uidField != null) {
            return;
        }
        if (Validator.isNull((String)alternateUidFieldName)) {
            return;
        }
        String uidValue = document.get(alternateUidFieldName);
        if (Validator.isNotNull((String)uidValue)) {
            uidField = new Field("uid", uidValue);
            document.add(uidField);
        }
    }

    protected Document processSearchHit(SearchHit searchHit, String alternateUidFieldName) {
        Document document = this.searchHitDocumentTranslator.translate(searchHit);
        this.populateUID(document, alternateUidFieldName);
        return document;
    }

    protected Hits processSearchHits(SearchHits searchHits, Hits hits, String alternateUidFieldName, String[] highlightFieldNames, Locale locale) {
        ArrayList<Document> documents = new ArrayList<Document>();
        ArrayList<Float> scores = new ArrayList<Float>();
        if (searchHits.getTotalHits() > 0L) {
            SearchHit[] searchHitsArray;
            for (SearchHit searchHit : searchHitsArray = searchHits.getHits()) {
                Document document = this.processSearchHit(searchHit, alternateUidFieldName);
                documents.add(document);
                scores.add(Float.valueOf(searchHit.getScore()));
                this.addSnippets(searchHit, document, highlightFieldNames, locale);
            }
        }
        hits.setDocs(documents.toArray(new Document[documents.size()]));
        hits.setLength((int)searchHits.getTotalHits());
        hits.setQueryTerms(new String[0]);
        hits.setScores(ArrayUtil.toFloatArray(scores));
        return hits;
    }

    protected void updateFacetCollectors(SearchResponse searchResponse, Map<String, Facet> facetsMap) {
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return;
        }
        Map aggregationsMap = aggregations.getAsMap();
        for (Facet facet : facetsMap.values()) {
            if (facet.isStatic()) continue;
            facet.setFacetCollector(this.getFacetCollector(facet, aggregationsMap));
        }
    }

    protected void updateGroupedHits(SearchResponse searchResponse, GroupBy groupBy, Hits hits, String alternateUidFieldName, String[] highlightFieldNames, Locale locale) {
        if (groupBy == null) {
            return;
        }
        Aggregations aggregations = searchResponse.getAggregations();
        Map aggregationsMap = aggregations.getAsMap();
        Terms terms = (Terms)aggregationsMap.get("GroupBy_" + groupBy.getField());
        List buckets = terms.getBuckets();
        for (Terms.Bucket bucket : buckets) {
            Aggregations bucketAggregations = bucket.getAggregations();
            TopHits topHits = (TopHits)bucketAggregations.get("_topHits");
            SearchHits groupedSearchHits = topHits.getHits();
            HitsImpl groupedHits = new HitsImpl();
            this.processSearchHits(groupedSearchHits, (Hits)groupedHits, alternateUidFieldName, highlightFieldNames, locale);
            groupedHits.setLength((int)groupedSearchHits.getTotalHits());
            hits.addGroupedHits(bucket.getKeyAsString(), (Hits)groupedHits);
        }
    }

    protected void updateStatsResults(SearchResponse searchResponse, Hits hits, Map<String, Stats> statsMap) {
        if (statsMap.isEmpty()) {
            return;
        }
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            return;
        }
        Map aggregationsMap = aggregations.getAsMap();
        for (Stats stats : statsMap.values()) {
            if (!stats.isEnabled()) continue;
            StatsResults statsResults = this.statsTranslator.translate(aggregationsMap, stats);
            hits.addStatsResults(statsResults);
        }
    }
}

