/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.GroupBy;
import com.liferay.portal.kernel.search.Stats;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.elasticsearch6.internal.groupby.GroupByTranslator;
import com.liferay.portal.search.elasticsearch6.internal.highlight.HighlighterTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CommonSearchRequestBuilderAssembler;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.SearchSearchRequestAssembler;
import com.liferay.portal.search.elasticsearch6.internal.sort.SortTranslator;
import com.liferay.portal.search.elasticsearch6.internal.stats.StatsTranslator;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SearchSearchRequestAssembler.class})
public class SearchSearchRequestAssemblerImpl
implements SearchSearchRequestAssembler {
    @Reference
    protected CommonSearchRequestBuilderAssembler commonSearchRequestBuilderAssembler;
    @Reference
    protected GroupByTranslator groupByTranslator;
    @Reference
    protected HighlighterTranslator highlighterTranslator;
    @Reference
    protected SortTranslator sortTranslator;
    @Reference
    protected StatsTranslator statsTranslator;

    @Override
    public void assemble(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        this.commonSearchRequestBuilderAssembler.assemble(searchRequestBuilder, (BaseSearchRequest)searchSearchRequest);
        Map stats = searchSearchRequest.getStats();
        if (!MapUtil.isEmpty((Map)stats)) {
            stats.forEach((statsKey, stat) -> this.statsTranslator.translate(searchRequestBuilder, (Stats)stat));
        }
        this.addGroupBy(searchRequestBuilder, searchSearchRequest);
        if (searchSearchRequest.isHighlightEnabled()) {
            this.highlighterTranslator.translate(searchRequestBuilder, searchSearchRequest.getLocale(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize(), searchSearchRequest.isLuceneSyntax());
        }
        this.addPagination(searchRequestBuilder, searchSearchRequest.getStart(), searchSearchRequest.getSize());
        this.addPreference(searchRequestBuilder, searchSearchRequest);
        this.addSelectedFields(searchRequestBuilder, searchSearchRequest.getSelectedFieldNames());
        this.sortTranslator.translate(searchRequestBuilder, searchSearchRequest.getSorts());
        searchRequestBuilder.setTrackScores(searchSearchRequest.isScoreEnabled());
    }

    protected void addGroupBy(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        GroupBy groupBy = searchSearchRequest.getGroupBy();
        if (groupBy == null) {
            return;
        }
        this.groupByTranslator.translate(searchRequestBuilder, groupBy, searchSearchRequest.getSorts(), searchSearchRequest.getLocale(), searchSearchRequest.getSelectedFieldNames(), searchSearchRequest.getHighlightFieldNames(), searchSearchRequest.isHighlightEnabled(), searchSearchRequest.isHighlightRequireFieldMatch(), searchSearchRequest.getHighlightFragmentSize(), searchSearchRequest.getHighlightSnippetSize(), searchSearchRequest.getStart(), searchSearchRequest.getSize());
    }

    protected void addPagination(SearchRequestBuilder searchRequestBuilder, int start, int size) {
        searchRequestBuilder.setFrom(start);
        searchRequestBuilder.setSize(size);
    }

    protected void addPreference(SearchRequestBuilder searchRequestBuilder, SearchSearchRequest searchSearchRequest) {
        String preference = searchSearchRequest.getPreference();
        if (!Validator.isBlank((String)preference)) {
            searchRequestBuilder.setPreference(preference);
        }
    }

    protected void addSelectedFields(SearchRequestBuilder searchRequestBuilder, String[] selectedFieldNames) {
        if (ArrayUtil.isEmpty((Object[])selectedFieldNames)) {
            searchRequestBuilder.addStoredField("*");
        } else {
            searchRequestBuilder.storedFields(selectedFieldNames);
        }
    }
}

