/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search;

import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.FilterTranslator;
import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.facet.FacetTranslator;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.search.CommonSearchRequestBuilderAssembler;
import com.liferay.portal.search.engine.adapter.search.BaseSearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={CommonSearchRequestBuilderAssembler.class})
public class CommonSearchRequestBuilderAssemblerImpl
implements CommonSearchRequestBuilderAssembler {
    @Reference
    protected FacetTranslator facetTranslator;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected FilterTranslator<QueryBuilder> filterTranslator;
    @Reference(target="(search.engine.impl=Elasticsearch)")
    protected QueryTranslator<QueryBuilder> queryTranslator;

    @Override
    public void assemble(SearchRequestBuilder searchRequestBuilder, BaseSearchRequest baseSearchRequest) {
        searchRequestBuilder.setIndices(baseSearchRequest.getIndexNames());
        if (baseSearchRequest.getMinimumScore() > 0.0f) {
            searchRequestBuilder.setMinScore(baseSearchRequest.getMinimumScore());
        }
        if (baseSearchRequest.getPostFilter() != null) {
            QueryBuilder postFilterQueryBuilder = (QueryBuilder)this.filterTranslator.translate(baseSearchRequest.getPostFilter(), null);
            searchRequestBuilder.setPostFilter(postFilterQueryBuilder);
        }
        searchRequestBuilder.setQuery(this.getQueryBuilder(baseSearchRequest));
        if (baseSearchRequest.isRequestCache()) {
            searchRequestBuilder.setRequestCache(Boolean.valueOf(baseSearchRequest.isRequestCache()));
        }
        if (baseSearchRequest.getTimeoutInMilliseconds() > 0L) {
            searchRequestBuilder.setTimeout(TimeValue.timeValueMillis((long)baseSearchRequest.getTimeoutInMilliseconds()));
        }
        searchRequestBuilder.setTrackTotalHits(baseSearchRequest.isTrackTotalHits());
        this.facetTranslator.translate(searchRequestBuilder, baseSearchRequest.getQuery(), baseSearchRequest.getFacets(), baseSearchRequest.isBasicFacetSelection());
    }

    protected QueryBuilder getQueryBuilder(BaseSearchRequest searchSearchRequest) {
        Query query = searchSearchRequest.getQuery();
        QueryBuilder queryBuilder = (QueryBuilder)this.queryTranslator.translate(query, null);
        if (query.getPreBooleanFilter() == null) {
            return queryBuilder;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)this.filterTranslator.translate((Filter)query.getPreBooleanFilter(), null));
        boolQueryBuilder.must(queryBuilder);
        return boolQueryBuilder;
    }
}

