/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index;

import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.index.CreateIndexRequestExecutor;
import com.liferay.portal.search.engine.adapter.index.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CreateIndexRequestExecutor.class})
public class CreateIndexRequestExecutorImpl
implements CreateIndexRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public com.liferay.portal.search.engine.adapter.index.CreateIndexResponse execute(CreateIndexRequest createIndexRequest) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.createCreateIndexRequestBuilder(createIndexRequest);
        CreateIndexResponse elasticsearchCreateIndexResponse = (CreateIndexResponse)createIndexRequestBuilder.get();
        com.liferay.portal.search.engine.adapter.index.CreateIndexResponse createIndexResponse = new com.liferay.portal.search.engine.adapter.index.CreateIndexResponse(elasticsearchCreateIndexResponse.isAcknowledged());
        return createIndexResponse;
    }

    protected CreateIndexRequestBuilder createCreateIndexRequestBuilder(CreateIndexRequest createIndexRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        CreateIndexRequestBuilder createIndexRequestBuilder = CreateIndexAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        createIndexRequestBuilder.setIndex(createIndexRequest.getIndexName());
        createIndexRequestBuilder.setSource(createIndexRequest.getSource(), XContentType.JSON);
        return createIndexRequestBuilder;
    }
}

