/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document.UpdateByQueryDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequestBuilder;
import org.elasticsearch.script.Script;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={UpdateByQueryDocumentRequestExecutor.class})
public class UpdateByQueryDocumentRequestExecutorImpl
implements UpdateByQueryDocumentRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public UpdateByQueryDocumentResponse execute(UpdateByQueryDocumentRequest updateByQueryDocumentRequest) {
        UpdateByQueryRequestBuilder updateByQueryRequestBuilder = this.createUpdateByQueryRequestBuilder(updateByQueryDocumentRequest);
        BulkByScrollResponse bulkByScrollResponse = (BulkByScrollResponse)updateByQueryRequestBuilder.get();
        TimeValue timeValue = bulkByScrollResponse.getTook();
        UpdateByQueryDocumentResponse updateByQueryDocumentResponse = new UpdateByQueryDocumentResponse(bulkByScrollResponse.getUpdated(), timeValue.getMillis());
        return updateByQueryDocumentResponse;
    }

    protected UpdateByQueryRequestBuilder createUpdateByQueryRequestBuilder(UpdateByQueryDocumentRequest updateByQueryDocumentRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        UpdateByQueryRequestBuilder updateByQueryRequestBuilder = UpdateByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        Query query = updateByQueryDocumentRequest.getQuery();
        QueryStringQueryBuilder queryBuilder = new QueryStringQueryBuilder(query.toString());
        updateByQueryRequestBuilder.filter((QueryBuilder)queryBuilder);
        updateByQueryRequestBuilder.refresh(updateByQueryDocumentRequest.isRefresh());
        JSONObject jsonObject = updateByQueryDocumentRequest.getScriptJSONObject();
        if (jsonObject != null) {
            Script script = new Script(jsonObject.toString());
            updateByQueryRequestBuilder.script(script);
        }
        updateByQueryRequestBuilder.source(updateByQueryDocumentRequest.getIndexNames());
        return updateByQueryRequestBuilder;
    }
}

