/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document;

import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.search.elasticsearch6.internal.connection.ElasticsearchConnectionManager;
import com.liferay.portal.search.elasticsearch6.internal.search.engine.adapter.document.DeleteByQueryDocumentRequestExecutor;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequestBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DeleteByQueryDocumentRequestExecutor.class})
public class DeleteByQueryDocumentRequestExecutorImpl
implements DeleteByQueryDocumentRequestExecutor {
    @Reference
    protected ElasticsearchConnectionManager elasticsearchConnectionManager;

    @Override
    public DeleteByQueryDocumentResponse execute(DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {
        DeleteByQueryRequestBuilder deleteByQueryRequestBuilder = this.createDeleteByQueryRequestBuilder(deleteByQueryDocumentRequest);
        BulkByScrollResponse bulkByScrollResponse = (BulkByScrollResponse)deleteByQueryRequestBuilder.get();
        TimeValue timeValue = bulkByScrollResponse.getTook();
        DeleteByQueryDocumentResponse deleteByQueryDocumentResponse = new DeleteByQueryDocumentResponse(bulkByScrollResponse.getDeleted(), timeValue.getMillis());
        return deleteByQueryDocumentResponse;
    }

    protected DeleteByQueryRequestBuilder createDeleteByQueryRequestBuilder(DeleteByQueryDocumentRequest deleteByQueryDocumentRequest) {
        Client client = this.elasticsearchConnectionManager.getClient();
        DeleteByQueryRequestBuilder deleteByQueryRequestBuilder = DeleteByQueryAction.INSTANCE.newRequestBuilder((ElasticsearchClient)client);
        Query query = deleteByQueryDocumentRequest.getQuery();
        QueryStringQueryBuilder queryBuilder = new QueryStringQueryBuilder(query.toString());
        deleteByQueryRequestBuilder.filter((QueryBuilder)queryBuilder);
        deleteByQueryRequestBuilder.refresh(deleteByQueryDocumentRequest.isRefresh());
        deleteByQueryRequestBuilder.source(deleteByQueryDocumentRequest.getIndexNames());
        return deleteByQueryRequestBuilder;
    }
}

