/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.query;

import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.TermQuery;
import com.liferay.portal.kernel.search.TermRangeQuery;
import com.liferay.portal.kernel.search.WildcardQuery;
import com.liferay.portal.kernel.search.generic.DisMaxQuery;
import com.liferay.portal.kernel.search.generic.FuzzyQuery;
import com.liferay.portal.kernel.search.generic.MatchAllQuery;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.search.generic.MoreLikeThisQuery;
import com.liferay.portal.kernel.search.generic.MultiMatchQuery;
import com.liferay.portal.kernel.search.generic.NestedQuery;
import com.liferay.portal.kernel.search.generic.StringQuery;
import com.liferay.portal.kernel.search.query.QueryTranslator;
import com.liferay.portal.kernel.search.query.QueryVisitor;
import com.liferay.portal.search.elasticsearch6.internal.query.BooleanQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.DisMaxQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.FuzzyQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.MatchAllQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.MatchQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.MoreLikeThisQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.MultiMatchQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.NestedQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.StringQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.TermQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.TermRangeQueryTranslator;
import com.liferay.portal.search.elasticsearch6.internal.query.WildcardQueryTranslator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"search.engine.impl=Elasticsearch"}, service={QueryTranslator.class})
public class ElasticsearchQueryTranslator
implements QueryTranslator<QueryBuilder>,
QueryVisitor<QueryBuilder> {
    @Reference
    protected BooleanQueryTranslator booleanQueryTranslator;
    @Reference
    protected DisMaxQueryTranslator disMaxQueryTranslator;
    @Reference
    protected FuzzyQueryTranslator fuzzyQueryTranslator;
    @Reference
    protected MatchAllQueryTranslator matchAllQueryTranslator;
    @Reference
    protected MatchQueryTranslator matchQueryTranslator;
    @Reference
    protected MoreLikeThisQueryTranslator moreLikeThisQueryTranslator;
    @Reference
    protected MultiMatchQueryTranslator multiMatchQueryTranslator;
    @Reference
    protected NestedQueryTranslator nestedQueryTranslator;
    @Reference
    protected StringQueryTranslator stringQueryTranslator;
    @Reference
    protected TermQueryTranslator termQueryTranslator;
    @Reference
    protected TermRangeQueryTranslator termRangeQueryTranslator;
    @Reference
    protected WildcardQueryTranslator wildcardQueryTranslator;

    public QueryBuilder translate(Query query, SearchContext searchContext) {
        QueryBuilder queryBuilder = (QueryBuilder)query.accept((QueryVisitor)this);
        if (queryBuilder == null) {
            queryBuilder = QueryBuilders.queryStringQuery((String)query.toString());
        }
        return queryBuilder;
    }

    public QueryBuilder visitQuery(BooleanQuery booleanQuery) {
        return this.booleanQueryTranslator.translate(booleanQuery, this);
    }

    public QueryBuilder visitQuery(DisMaxQuery disMaxQuery) {
        return this.disMaxQueryTranslator.translate(disMaxQuery, this);
    }

    public QueryBuilder visitQuery(FuzzyQuery fuzzyQuery) {
        return this.fuzzyQueryTranslator.translate(fuzzyQuery);
    }

    public QueryBuilder visitQuery(MatchAllQuery matchAllQuery) {
        return this.matchAllQueryTranslator.translate(matchAllQuery);
    }

    public QueryBuilder visitQuery(MatchQuery matchQuery) {
        return this.matchQueryTranslator.translate(matchQuery);
    }

    public QueryBuilder visitQuery(MoreLikeThisQuery moreLikeThisQuery) {
        return this.moreLikeThisQueryTranslator.translate(moreLikeThisQuery);
    }

    public QueryBuilder visitQuery(MultiMatchQuery multiMatchQuery) {
        return this.multiMatchQueryTranslator.translate(multiMatchQuery);
    }

    public QueryBuilder visitQuery(NestedQuery nestedQuery) {
        return this.nestedQueryTranslator.translate(nestedQuery, this);
    }

    public QueryBuilder visitQuery(StringQuery stringQuery) {
        return this.stringQueryTranslator.translate(stringQuery);
    }

    public QueryBuilder visitQuery(TermQuery termQuery) {
        return this.termQueryTranslator.translate(termQuery);
    }

    public QueryBuilder visitQuery(TermRangeQuery termRangeQuery) {
        return this.termRangeQueryTranslator.translate(termRangeQuery);
    }

    public QueryBuilder visitQuery(WildcardQuery wildcardQuery) {
        return this.wildcardQueryTranslator.translate(wildcardQuery);
    }
}

