/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.elasticsearch6.internal.connection;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.elasticsearch6.internal.connection.PluginManager;
import com.liferay.portal.search.elasticsearch6.internal.connection.PluginManagerFactory;
import com.liferay.portal.search.elasticsearch6.internal.connection.PluginZip;
import com.liferay.portal.search.elasticsearch6.internal.connection.PluginZipFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.elasticsearch.Version;

public class EmbeddedElasticsearchPluginManager {
    private static final Log _log = LogFactoryUtil.getLog(EmbeddedElasticsearchPluginManager.class);
    private final PluginManagerFactory _pluginManagerFactory;
    private final String _pluginName;
    private final String _pluginsPathString;
    private final PluginZipFactory _pluginZipFactory;
    private final Map<String, String> _pluginZipFileNames = new HashMap<String, String>(){
        {
            this.put("analysis-icu", "org.elasticsearch.plugin.analysis.icu");
            this.put("analysis-kuromoji", "org.elasticsearch.plugin.analysis.kuromoji");
            this.put("analysis-smartcn", "org.elasticsearch.plugin.analysis.smartcn");
            this.put("analysis-stempel", "org.elasticsearch.plugin.analysis.stempel");
        }
    };

    public EmbeddedElasticsearchPluginManager(String pluginName, String pluginsPathString, PluginManagerFactory pluginManagerFactory, PluginZipFactory pluginZipFactory) {
        this._pluginName = pluginName;
        this._pluginsPathString = pluginsPathString;
        this._pluginManagerFactory = pluginManagerFactory;
        this._pluginZipFactory = pluginZipFactory;
    }

    public void install() throws Exception {
        if (this.isAlreadyInstalled()) {
            return;
        }
        PluginZip pluginZip = this.createPluginZip();
        try {
            this.downloadAndExtract(pluginZip);
        }
        finally {
            pluginZip.delete();
        }
    }

    public void removeObsoletePlugin() throws Exception {
        PluginManager pluginManager = this._pluginManagerFactory.createPluginManager();
        Optional<Path> pathOptional = this.getInstalledPluginPath(pluginManager);
        if (!pathOptional.isPresent()) {
            return;
        }
        if (pluginManager.isCurrentVersion(pathOptional.get())) {
            return;
        }
        pluginManager.remove(this._pluginName);
    }

    protected PluginZip createPluginZip() throws IOException {
        return this._pluginZipFactory.createPluginZip(StringBundler.concat((Object[])new Object[]{"/plugins/", this.getPluginZipFileName(this._pluginName), "-", Version.CURRENT, ".zip"}));
    }

    protected void downloadAndExtract(PluginZip pluginZip) throws Exception {
        block2: {
            File file = new File(this._pluginsPathString);
            file.mkdirs();
            PluginManager pluginManager = this._pluginManagerFactory.createPluginManager(pluginZip);
            try {
                pluginManager.install(this._pluginName);
            }
            catch (IOException ioe) {
                if (this.handle(ioe)) break block2;
                throw ioe;
            }
        }
    }

    protected Optional<Path> getInstalledPluginPath(PluginManager pluginManager) throws IOException {
        return Stream.of(pluginManager.getInstalledPluginsPaths()).filter(path -> path.endsWith(this._pluginName)).findAny();
    }

    protected String getPluginZipFileName(String pluginName) {
        return this._pluginZipFileNames.get(pluginName);
    }

    protected boolean handle(IOException ioe) {
        String message = ioe.getMessage();
        if (message == null) {
            return false;
        }
        if (message.contains("already exists. To update the plugin, uninstall it first")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping plugin " + this._pluginName + " because it is already installed"), (Throwable)ioe);
            }
            return true;
        }
        return false;
    }

    protected boolean isAlreadyInstalled() throws IOException {
        PluginManager pluginManager = this._pluginManagerFactory.createPluginManager();
        Optional<Path> pathOptional = this.getInstalledPluginPath(pluginManager);
        return pathOptional.isPresent();
    }
}

